/*****************************************************************************/
// Printers Preference Application.
//
// This application and all source files used in its construction, except 
// where noted, are licensed under the MIT License, and have been written 
// and are:
//
// Copyright (c) 2001-2003 OpenBeOS Project
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
/*****************************************************************************/

#include "SpoolFolder.h"
#include "JobListView.h"
#include "pr_server.h"

#include "Messages.h"
#include "Globals.h"
#include "Jobs.h"
#include "PrintersWindow.h"

#include <Messenger.h>
#include <Bitmap.h>
#include <String.h>
#include <Alert.h>
#include <Mime.h>
#include <Roster.h>

SpoolFolder::SpoolFolder(PrintersWindow* window, PrinterItem* item, const BDirectory& spoolDir)
	: Folder(NULL, window, spoolDir)
	, fWindow(window)
	, fItem(item)
{
}

void SpoolFolder::Notify(Job* job, int kind) 
{
	switch (kind) {
		case kJobAdded: fWindow->AddJob(this, job);
			break;
		case kJobRemoved: fWindow->RemoveJob(this, job);
			break;
		case kJobAttrChanged: fWindow->UpdateJob(this, job);
			break;
		default: ;
	}
}
