/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_SPORT_CONTROLS_H
#define _USB_HID_PAGE_SPORT_CONTROLS_H


/* Reference:
 *		HID Usage Page 0x04: SPORT CONTROLS
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_SPO_BASEBALL_BAT = 0x1,
	B_HID_UID_SPO_GOLF_CLUB,
	B_HID_UID_SPO_ROWING_MACHINE,
	B_HID_UID_SPO_TREADMILL,
	
	B_HID_UID_SPO_OAR = 0x30,
	B_HID_UID_SPO_SLOPE,
	B_HID_UID_SPO_RATE,
	B_HID_UID_SPO_STICK_SPEED,
	B_HID_UID_SPO_STICK_FACE_ANGLE,
	B_HID_UID_SPO_STICK_HEEL_TOE,
	B_HID_UID_SPO_STICK_TEMPO,
	B_HID_UID_SPO_STICK_TYPE,
	B_HID_UID_SPO_STICK_HEIGHT,
	
	B_HID_UID_SPO_PUTTER = 0x50,
	B_HID_UID_SPO_1_IRON,
	B_HID_UID_SPO_2_IRON,
	B_HID_UID_SPO_3_IRON,
	B_HID_UID_SPO_4_IRON,
	B_HID_UID_SPO_5_IRON,
	B_HID_UID_SPO_6_IRON,
	B_HID_UID_SPO_7_IRON,
	B_HID_UID_SPO_8_IRON,
	B_HID_UID_SPO_9_IRON,
	B_HID_UID_SPO_10_IRON,
	B_HID_UID_SPO_11_IRON,
	B_HID_UID_SPO_SAND_WEDGE,
	B_HID_UID_SPO_LOFT_WEDGE,
	B_HID_UID_SPO_POWER_WEDGE,
	B_HID_UID_SPO_1_WOOD,
	B_HID_UID_SPO_3_WOOD,
	B_HID_UID_SPO_5_WOOD,
	B_HID_UID_SPO_7_WOOD,
	B_HID_UID_SPO_9_WOOD
};


#endif // _USB_HID_PAGE_SPORT_CONTROLS_H
