/* generated by MKkeyname.awk */

#include <curses.priv.h>
#include <tic.h>
#include <term_entry.h>

const struct kn _nc_key_names[] = {
	{ "KEY_A1", KEY_A1 },
	{ "KEY_A3", KEY_A3 },
	{ "KEY_B2", KEY_B2 },
	{ "KEY_BACKSPACE", KEY_BACKSPACE },
	{ "KEY_BEG", KEY_BEG },
	{ "KEY_BREAK", KEY_BREAK },
	{ "KEY_BTAB", KEY_BTAB },
	{ "KEY_C1", KEY_C1 },
	{ "KEY_C3", KEY_C3 },
	{ "KEY_CANCEL", KEY_CANCEL },
	{ "KEY_CATAB", KEY_CATAB },
	{ "KEY_CLEAR", KEY_CLEAR },
	{ "KEY_CLOSE", KEY_CLOSE },
	{ "KEY_COMMAND", KEY_COMMAND },
	{ "KEY_COPY", KEY_COPY },
	{ "KEY_CREATE", KEY_CREATE },
	{ "KEY_CTAB", KEY_CTAB },
	{ "KEY_DC", KEY_DC },
	{ "KEY_DL", KEY_DL },
	{ "KEY_DOWN", KEY_DOWN },
	{ "KEY_EIC", KEY_EIC },
	{ "KEY_END", KEY_END },
	{ "KEY_ENTER", KEY_ENTER },
	{ "KEY_EOL", KEY_EOL },
	{ "KEY_EOS", KEY_EOS },
	{ "KEY_EXIT", KEY_EXIT },
	{ "KEY_F(0)", KEY_F(0) },
	{ "KEY_F(1)", KEY_F(1) },
	{ "KEY_F(10)", KEY_F(10) },
	{ "KEY_F(11)", KEY_F(11) },
	{ "KEY_F(12)", KEY_F(12) },
	{ "KEY_F(13)", KEY_F(13) },
	{ "KEY_F(14)", KEY_F(14) },
	{ "KEY_F(15)", KEY_F(15) },
	{ "KEY_F(16)", KEY_F(16) },
	{ "KEY_F(17)", KEY_F(17) },
	{ "KEY_F(18)", KEY_F(18) },
	{ "KEY_F(19)", KEY_F(19) },
	{ "KEY_F(2)", KEY_F(2) },
	{ "KEY_F(20)", KEY_F(20) },
	{ "KEY_F(21)", KEY_F(21) },
	{ "KEY_F(22)", KEY_F(22) },
	{ "KEY_F(23)", KEY_F(23) },
	{ "KEY_F(24)", KEY_F(24) },
	{ "KEY_F(25)", KEY_F(25) },
	{ "KEY_F(26)", KEY_F(26) },
	{ "KEY_F(27)", KEY_F(27) },
	{ "KEY_F(28)", KEY_F(28) },
	{ "KEY_F(29)", KEY_F(29) },
	{ "KEY_F(3)", KEY_F(3) },
	{ "KEY_F(30)", KEY_F(30) },
	{ "KEY_F(31)", KEY_F(31) },
	{ "KEY_F(32)", KEY_F(32) },
	{ "KEY_F(33)", KEY_F(33) },
	{ "KEY_F(34)", KEY_F(34) },
	{ "KEY_F(35)", KEY_F(35) },
	{ "KEY_F(36)", KEY_F(36) },
	{ "KEY_F(37)", KEY_F(37) },
	{ "KEY_F(38)", KEY_F(38) },
	{ "KEY_F(39)", KEY_F(39) },
	{ "KEY_F(4)", KEY_F(4) },
	{ "KEY_F(40)", KEY_F(40) },
	{ "KEY_F(41)", KEY_F(41) },
	{ "KEY_F(42)", KEY_F(42) },
	{ "KEY_F(43)", KEY_F(43) },
	{ "KEY_F(44)", KEY_F(44) },
	{ "KEY_F(45)", KEY_F(45) },
	{ "KEY_F(46)", KEY_F(46) },
	{ "KEY_F(47)", KEY_F(47) },
	{ "KEY_F(48)", KEY_F(48) },
	{ "KEY_F(49)", KEY_F(49) },
	{ "KEY_F(5)", KEY_F(5) },
	{ "KEY_F(50)", KEY_F(50) },
	{ "KEY_F(51)", KEY_F(51) },
	{ "KEY_F(52)", KEY_F(52) },
	{ "KEY_F(53)", KEY_F(53) },
	{ "KEY_F(54)", KEY_F(54) },
	{ "KEY_F(55)", KEY_F(55) },
	{ "KEY_F(56)", KEY_F(56) },
	{ "KEY_F(57)", KEY_F(57) },
	{ "KEY_F(58)", KEY_F(58) },
	{ "KEY_F(59)", KEY_F(59) },
	{ "KEY_F(6)", KEY_F(6) },
	{ "KEY_F(60)", KEY_F(60) },
	{ "KEY_F(61)", KEY_F(61) },
	{ "KEY_F(62)", KEY_F(62) },
	{ "KEY_F(63)", KEY_F(63) },
	{ "KEY_F(7)", KEY_F(7) },
	{ "KEY_F(8)", KEY_F(8) },
	{ "KEY_F(9)", KEY_F(9) },
	{ "KEY_FIND", KEY_FIND },
	{ "KEY_HELP", KEY_HELP },
	{ "KEY_HOME", KEY_HOME },
	{ "KEY_IC", KEY_IC },
	{ "KEY_IL", KEY_IL },
	{ "KEY_LEFT", KEY_LEFT },
	{ "KEY_LL", KEY_LL },
	{ "KEY_MARK", KEY_MARK },
	{ "KEY_MESSAGE", KEY_MESSAGE },
	{ "KEY_MOUSE", KEY_MOUSE },
	{ "KEY_MOVE", KEY_MOVE },
	{ "KEY_NEXT", KEY_NEXT },
	{ "KEY_NPAGE", KEY_NPAGE },
	{ "KEY_OPEN", KEY_OPEN },
	{ "KEY_OPTIONS", KEY_OPTIONS },
	{ "KEY_PPAGE", KEY_PPAGE },
	{ "KEY_PREVIOUS", KEY_PREVIOUS },
	{ "KEY_PRINT", KEY_PRINT },
	{ "KEY_REDO", KEY_REDO },
	{ "KEY_REFERENCE", KEY_REFERENCE },
	{ "KEY_REFRESH", KEY_REFRESH },
	{ "KEY_REPLACE", KEY_REPLACE },
	{ "KEY_RESET", KEY_RESET },
	{ "KEY_RESIZE", KEY_RESIZE },
	{ "KEY_RESTART", KEY_RESTART },
	{ "KEY_RESUME", KEY_RESUME },
	{ "KEY_RIGHT", KEY_RIGHT },
	{ "KEY_SAVE", KEY_SAVE },
	{ "KEY_SBEG", KEY_SBEG },
	{ "KEY_SCANCEL", KEY_SCANCEL },
	{ "KEY_SCOMMAND", KEY_SCOMMAND },
	{ "KEY_SCOPY", KEY_SCOPY },
	{ "KEY_SCREATE", KEY_SCREATE },
	{ "KEY_SDC", KEY_SDC },
	{ "KEY_SDL", KEY_SDL },
	{ "KEY_SELECT", KEY_SELECT },
	{ "KEY_SEND", KEY_SEND },
	{ "KEY_SEOL", KEY_SEOL },
	{ "KEY_SEXIT", KEY_SEXIT },
	{ "KEY_SF", KEY_SF },
	{ "KEY_SFIND", KEY_SFIND },
	{ "KEY_SHELP", KEY_SHELP },
	{ "KEY_SHOME", KEY_SHOME },
	{ "KEY_SIC", KEY_SIC },
	{ "KEY_SLEFT", KEY_SLEFT },
	{ "KEY_SMESSAGE", KEY_SMESSAGE },
	{ "KEY_SMOVE", KEY_SMOVE },
	{ "KEY_SNEXT", KEY_SNEXT },
	{ "KEY_SOPTIONS", KEY_SOPTIONS },
	{ "KEY_SPREVIOUS", KEY_SPREVIOUS },
	{ "KEY_SPRINT", KEY_SPRINT },
	{ "KEY_SR", KEY_SR },
	{ "KEY_SREDO", KEY_SREDO },
	{ "KEY_SREPLACE", KEY_SREPLACE },
	{ "KEY_SRESET", KEY_SRESET },
	{ "KEY_SRIGHT", KEY_SRIGHT },
	{ "KEY_SRSUME", KEY_SRSUME },
	{ "KEY_SSAVE", KEY_SSAVE },
	{ "KEY_SSUSPEND", KEY_SSUSPEND },
	{ "KEY_STAB", KEY_STAB },
	{ "KEY_SUNDO", KEY_SUNDO },
	{ "KEY_SUSPEND", KEY_SUSPEND },
	{ "KEY_UNDO", KEY_UNDO },
	{ "KEY_UP", KEY_UP },
	{ 0, 0 }};

NCURSES_EXPORT(NCURSES_CONST char *) keyname (int c)
{
	static char **table;
	int i;
	char name[20];
	char *p;
	NCURSES_CONST char *result = 0;

	if (c == -1) {
		result = "-1";
	} else {
		for (i = 0; _nc_key_names[i].name != 0; i++) {
			if (_nc_key_names[i].code == c) {
				result = (NCURSES_CONST char *)_nc_key_names[i].name;
				break;
			}
		}

		if (result == 0 && (c >= 0 && c < 256)) {
			if (table == 0)
				table = typeCalloc(char *, 256);
			if (table != 0) {
				if (table[c] == 0) {
					p = name;
					if (c >= 128) {
						strcpy(p, "M-");
						p += 2;
						c -= 128;
					}
					if (c < 32)
						sprintf(p, "^%c", c + '@');
					else if (c == 127)
						strcpy(p, "^?");
					else
						sprintf(p, "%c", c);
					table[c] = strdup(name);
				}
				result = table[c];
			}
#if NCURSES_EXT_FUNCS && NCURSES_XNAMES
		} else if (result == 0 && cur_term != 0) {
			int j, k;
			char * bound;
			TERMTYPE *tp = &(cur_term->type);
			int save_trace = _nc_tracing;

			_nc_tracing = 0;	/* prevent recursion via keybound() */
			for (j = 0; (bound = keybound(c, j)) != 0; ++j) {
				for(k = STRCOUNT; k < NUM_STRINGS(tp);  k++) {
					if (tp->Strings[k] != 0 && !strcmp(bound, tp->Strings[k])) {
						result = ExtStrname(tp, k, strnames);
						break;
					}
				}
				if (result != 0)
					break;
			}
			_nc_tracing = save_trace;
#endif
		}
	}
	return result;
}

#if USE_WIDEC_SUPPORT
NCURSES_EXPORT(NCURSES_CONST char *) key_name (wchar_t c)
{
	NCURSES_CONST char *result = keyname((int)c);
	if (!strncmp(result, "M-", 2)) result = 0;
	return result;
}
#endif
