//--------------------------------------------------------------------
//	
//	TestIcons.h
//
//	Written by: Owen Smith
//	
//--------------------------------------------------------------------

/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/

#ifndef _TestIcons_h
#define _TestIcons_h

//--------------------------------------------------------------------
//	These icons were generated with the help of the File Types
//	preference panel. I created these icons by editing the
//	resource file icons, using the File Types preference panel
//	and Icon-O-Matic. Then, I selected the menu command
//	File>Dump Icons in Icon-O-Matic. Finally, I copied and
//	pasted the icon data from the newly generated ~/Bitmaps.h.

#define NUM_TEST_ITEMS_ACROSS	3
#define NUM_TEST_ITEMS_DOWN		2

#define LARGE_ICON_BYTES		1024

const uint8 kLargeIconWidth = 32;
const uint8 kLargeIconHeight = 32;
const color_space kLargeIconColorSpace = B_COLOR_8_BIT;

#define MINI_ICON_BYTES			256

const uint8 kMiniIconWidth = 16;
const uint8 kMiniIconHeight = 16;
const color_space kMiniIconColorSpace = B_COLOR_8_BIT;

//--------------------------------------------------------------------
//	Large Test Icons

extern const uint8
kLargeTestIcons[NUM_TEST_ITEMS_DOWN][NUM_TEST_ITEMS_ACROSS][LARGE_ICON_BYTES] =
{
{	/* 1st row */

{	/* Icon 1 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
	0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
	0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x31,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
	0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x1b,0x1b,0x1b,0x1b,0x1b
},

{	/* Icon 2 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,
	0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x26,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x26,0x1b,0x1b,
	0x26,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,
	0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x1b,0x1b,0x1b,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x26,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x26,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x26,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x26,0x28,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,
	0x28,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
	0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x28,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
	0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x1b,0x1b,0x1b,0x1b,0x1b
},

{	/* Icon 3 */
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x39,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x3b,0x39,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x3b,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
	0x35,0x35,0x35,0x35,0x35,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x39,0x39,0x39,0x39,0x35,0x35,0x35,0x35,
	0x35,0x39,0x39,0x39,0x39,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x3b,0x3b,0x3b,0x39,0x39,0x39,0x39,
	0x39,0x39,0x3b,0x3b,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3b,0x3b,0x3b,0x3b,
	0x3b,0x3b,0x3b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
}

},	/* end of 1st row */

{	/* Row 2 */

{	/* Icon 4 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x92,0x92,0x92,0x92,0x92,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,
	0x52,0x52,0x52,0x52,0x52,0x52,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x92,0x92,0x92,0x92,0x92,0x92,0x92,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
},

{	/* Icon 5 */
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0xf8,0xf8,0xf8,
	0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x98,0x98,0x98,
	0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0xf8,
	0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0x98,0x98,
	0x98,0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x1b,
	0x1b,0x98,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,0x1b,0x1b,
	0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,0x1b,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x98,0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x98,0xf8,0xf8,0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x98,0x98,0x98,0xf8,0xf8,0xf8,0xfa,0xfa,0xfa,0xfa,
	0xfa,0xf8,0xf8,0xf8,0xf8,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x98,0x98,0x98,0xf8,0xf8,0xf8,0xf8,
	0xf8,0xf8,0x98,0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x98,0x98,0x98,0x98,
	0x98,0x98,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
}, 

{	/* Icon 6 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0xe9,
	0xe9,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0xef,0xef,
	0xef,0xef,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0xef,0x1b,0x1b,
	0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xef,0xe9,0xe9,0xe9,0xe9,0xe9,0xe9,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0xef,0xef,0xef,0xef,0xef,0xef,0xef,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0xe0,0xe0,0xe0,
	0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0xe9,
	0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0xef,0xef,0xef,
	0xef,0xe9,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0xef,0x1b,0x1b,
	0x1b,0xef,0xef,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,
	0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xef,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0xef,0xe9,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xef,0xef,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xef,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xef,0xe9,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,
	0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0xe9,0xef,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xef,0xef,0xe9,0xe9,0xe9,0xe9,0xe9,
	0xe9,0xe9,0xe9,0xe9,0xe9,0xef,0xef,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xef,0xef,0xef,0xef,0xef,
	0xef,0xef,0xef,0xef,0xef,0xef,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
}

}};

//--------------------------------------------------------------------
//	Mini Test Icons

extern const uint8
kMiniTestIcons[NUM_TEST_ITEMS_DOWN][NUM_TEST_ITEMS_ACROSS][MINI_ICON_BYTES] =
{
{	/* 1st row */

{	/* Icon 1 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2f,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2f,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,
	0x1b,0x1b,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2f,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x1b,0x1b
}, 

{	/* Icon 2 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x26,0x26,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x26,0x26,0x26,0x26,0x1b,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x26,0x26,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,
	0x1b,0x1b,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x26,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x1b,0x1b
}, 

{	/* Icon 3 */
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x39,0x39,0x39,0x39,0x35,0x35,0x35,0x35,0x35,0x39,0x39,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x39,0x39,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x39,0x39,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x39,0x39,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x39,0x35,0x35,0x35,0x35,0x35,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x1b,0x1b,
	0x1b,0x1b,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x39,0x1b,0x1b,
	0x1b,0x1b,0x39,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x39,0x39,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x39,0x39,0x35,0x35,0x35,0x35,0x39,0x39,0x39,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x39,0x39,0x39,0x39,0x39,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
}

},	/* end of 1st row */

{	/* 2nd row */

{	/* Icon 4 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x52,0x52,0x52,0x52,0x52,0x92,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x1b,0x1b,
	0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,
	0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,
	0x1b,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x92,0x1b,
	0x1b,0x1b,0x92,0x92,0x92,0x92,0x92,0x92,0x52,0x52,0x52,0x52,0x92,0x92,0x92,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x52,0x52,0x52,0x52,0x92,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x92,0x92,0x92,0x92,0x1b,0x1b,0x1b
},

{	/* Icon 5 */
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0x1b,0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0x1b,0x1b,
	0x1b,0x1b,0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0xf8,0xfa,0xfa,0xfa,0xfa,0xfa,0xf8,0xf8,0xf8,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
},

{	/* Icon 6 */
	0x1b,0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0xe0,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0x1b,0xe9,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,0x1b,0xe9,0xe9,0xe9,0xe9,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe9,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0x1b,0xe9,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,
	0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe0,0x1b,0x1b,0xe0,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,
	0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0x1b,0x1b,
	0x1b,0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0xe9,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe9,0xe9,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0xe9,0xe9,0xe9,0xe9,0xe9,0xe9,0xe9,0x1b,0x1b,0x1b,0x1b
}

}};

#endif /* _TestIcons_h */