/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class FormatCallout {
    protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static final String xhURI = "http://www.w3.org/1999/xhtml";
    protected boolean foStylesheet = false;
    protected NamePool namePool = null;

    public FormatCallout(NamePool namePool, boolean bl) {
        this.namePool = namePool;
        this.foStylesheet = bl;
    }

    public String areaLabel(Element element) {
        String string = null;
        if (element.hasAttribute("label")) {
            string = element.getAttribute("label");
        } else {
            Element element2 = (Element)element.getParentNode();
            if (element2 != null && element2.getLocalName().equalsIgnoreCase("areaset") && element2.hasAttribute("label")) {
                string = element2.getAttribute("label");
            }
        }
        return string;
    }

    public void startSpan(Emitter emitter) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            int n = this.namePool.allocate("", "", "span");
            AttributeCollection attributeCollection = new AttributeCollection(this.namePool);
            int[] nArray = new int[1];
            attributeCollection.addAttribute("", "", "class", "CDATA", "co");
            emitter.startElement(n, (Attributes)attributeCollection, nArray, 0);
        }
    }

    public void endSpan(Emitter emitter) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            int n = this.namePool.allocate("", "", "span");
            emitter.endElement(n);
        }
    }

    public void formatTextCallout(Emitter emitter, Callout callout) {
        Element element = callout.getArea();
        int n = callout.getCallout();
        String string = this.areaLabel(element);
        String string2 = "(" + n + ")";
        if (string != null) {
            string2 = string;
        }
        char[] cArray = string2.toCharArray();
        try {
            this.startSpan(emitter);
            emitter.characters(cArray, 0, string2.length());
            this.endSpan(emitter);
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in formatTextCallout");
        }
    }

    public abstract void formatCallout(Emitter var1, Callout var2);
}

