/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_ALPHANUMERIC_DISPLAY_H
#define _USB_HID_PAGE_ALPHANUMERIC_DISPLAY_H


/* Reference:
 *		HID Usage Page 0x14: ALPHANUMERIC DISPLAY
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */
 
// Usage IDs
enum {
	B_HID_UID_AD_ALPHANUMERIC_DISPLAY = 0x01,
	B_HID_UID_AD_BITMAPPED_DISPLAY,
	
	B_HID_UID_AD_DISPLAY_ATTRIBUTES_REPORT = 0x20,
	B_HID_UID_AD_ASCII_CHARACTER_SET,
	B_HID_UID_AD_DATA_READ_BACK,
	B_HID_UID_AD_FONT_READ_BACK,
	B_HID_UID_AD_DISPLAY_CONTROL_REPORT,
	B_HID_UID_AD_CLEAR_DISPLAY,
	B_HID_UID_AD_DISPLAY_ENABLE,
	B_HID_UID_AD_SCREEN_SAVER_DELAY,
	B_HID_UID_AD_SCREEN_SAVER_ENABLE,
	B_HID_UID_AD_VERTICAL_SCROLL,
	B_HID_UID_AD_HORIZONTAL_SCROLL,
	B_HID_UID_AD_CHARACTER_REPORT,
	B_HID_UID_AD_DISPLAY_DATA,
	B_HID_UID_AD_DISPLAY_STATUS,
	B_HID_UID_AD_STAT_NOT_READY,
	B_HID_UID_AD_STAT_READY,
	B_HID_UID_AD_ERR_NOT_A_LOADABLE_CHARACTER,
	B_HID_UID_AD_ERR_FONT_DATA_CANNOT_BE_READ,
	B_HID_UID_AD_CURSOR_POSITION_REPORT,
	B_HID_UID_AD_ROW,
	B_HID_UID_AD_COLUMN,
	B_HID_UID_AD_ROWS,
	B_HID_UID_AD_COLUMNS,
	B_HID_UID_AD_CURSOR_PIXEL_POSITIONING,
	B_HID_UID_AD_CURSOR_MODE,
	B_HID_UID_AD_CURSOR_ENABLE,
	B_HID_UID_AD_CURSOR_BLINK,
	B_HID_UID_AD_FONT_REPORT,
	B_HID_UID_AD_FONT_DATA,
	B_HID_UID_AD_CHARACTER_WIDTH,
	B_HID_UID_AD_CHARACTER_HEIGHT,
	B_HID_UID_AD_CHARACTER_SPACING_HORIZONTAL,
	B_HID_UID_AD_CHARACTER_SPACING_VERTICAL,
	B_HID_UID_AD_UNICODE_CHARACTER,
	B_HID_UID_AD_FONT_7_SEGMENT,
	B_HID_UID_AD_7_SEGMENT_DIRECT_MAP,
	B_HID_UID_AD_FONT_14_SEGMENT,
	B_HID_UID_AD_14_SEGMENT_DIRECT_MAP,
	B_HID_UID_AD_DISPLAY_BRIGHTNESS,
	B_HID_UID_AD_DISPLAY_CONTRAST,
	B_HID_UID_AD_CHARACTER_ATTRIBUTE,
	B_HID_UID_AD_ATTRIBUTE_READBACK,
	B_HID_UID_AD_ATTRIBUTE_DATA,
	B_HID_UID_AD_CHAR_ATTR_ENHANCE,
	B_HID_UID_AD_CHAR_ATTR_UNDERLINE,
	B_HID_UID_AD_CHAR_ATTR_BLINK,
	
	B_HID_UID_AD_BITMAP_SIZE_X = 0x80,
	B_HID_UID_AD_BITMAP_SIZE_Y,
	
	B_HID_UID_AD_BIT_DEPTH_FORMAT = 0x83,
	B_HID_UID_AD_DISPLAY_ORIENTATION,
	B_HID_UID_AD_PALETTE_REPORT,
	B_HID_UID_AD_PALETTE_DATA_SIZE,
	B_HID_UID_AD_PALETTE_DATA_OFFSET,
	B_HID_UID_AD_PALETTE_DATA,
	B_HID_UID_AD_BLIT_REPORT,
	B_HID_UID_AD_BLIT_RECT_X1,
	B_HID_UID_AD_BLIT_RECT_Y1,
	B_HID_UID_AD_BLIT_RECT_X2,
	B_HID_UID_AD_BLIT_RECT_Y2,
	B_HID_UID_AD_BLIT_DATA,
	B_HID_UID_AD_SOFT_BUTTON,
	B_HID_UID_AD_SOFT_BUTTON_ID,
	B_HID_UID_AD_SOFT_BUTTON_SIDE,
	B_HID_UID_AD_SOFT_BUTTON_OFFSET_1,
	B_HID_UID_AD_SOFT_BUTTON_OFFSET_2,
	B_HID_UID_AD_SOFT_BUTTON_REPORT	
};


#endif // _USB_HID_PAGE_ALPHANUMERIC_DISPLAY_H
