/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_ARCADE_H
#define _USB_HID_PAGE_ARCADE_H


/* Reference:
 *		HID Usage Page 24: ARCADE
 *		Open Arcade Architecture Device (OAAD) -
 *		Data Format Specification Rev. 1.100
 *		http://www.usb.org/developers/devclass_docs/oaaddataformatsv6.pdf
 */

// Usage IDs
enum {
	B_HID_UID_ARC_GENERAL_PURPOSE_IO_CARD = 0x01,
	B_HID_UID_ARC_COIN_DOOR,
	B_HID_UID_ARC_WATCHDOG_TIMER,
	
	B_HID_UID_ARC_GENERAL_PURPOSE_ANALOG_INPUT_STATE = 0x30,
	B_HID_UID_ARC_GENERAL_PURPOSE_DIGITAL_INPUT_STATE,
	B_HID_UID_ARC_GENERAL_OPTICAL_INPUT_STATE,
	B_HID_UID_ARC_GENERAL_DIGITAL_OUTPUT_STATE,
	B_HID_UID_ARC_NUMBER_OF_COIN_DOORS,
	B_HID_UID_ARC_COIN_DRAWER_DROP_COUNT,
	B_HID_UID_ARC_COIN_DRAWER_START,
	B_HID_UID_ARC_COIN_DRAWER_SERVICE,
	B_HID_UID_ARC_COIN_DRAWER_TILT,
	B_HID_UID_ARC_COIN_DOOR_TEST,
	B_HID_UID_ARC_COIN_DOOR_LOCKOUT,
	B_HID_UID_ARC_WATCHDOG_TIMEOUT,
	B_HID_UID_ARC_WATCHDOG_REBOOT,
	B_HID_UID_ARC_WATCHDOG_RESTART,
	B_HID_UID_ARC_ALARM_INPUT,
	B_HID_UID_ARC_COIN_DOOR_COUNTER,
	B_HID_UID_ARC_IO_DIRECTION_MAPPING,
	B_HID_UID_ARC_SET_IO_DIRECTION,
	B_HID_UID_ARC_EXTENDED_OPTICAL_INPUT_STATE,
	B_HID_UID_ARC_PIN_PAD_INPUT_STATE,
	B_HID_UID_ARC_PIN_PAD_STATUS,
	B_HID_UID_ARC_PIN_PAD_OUTPUT,
	B_HID_UID_ARC_PIN_PAD_COMMAND	
};


#endif // _USB_HID_PAGE_ARCADE_H
