/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_CONSUMER_H
#define _USB_HID_PAGE_CONSUMER_H


/* Reference:
 *		HID Usage Page 0x0C: CONSUMER
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_CON_CONSUMER_CONTROL = 0x01,
	B_HID_UID_CON_NUMERIC_KEYPAD,
	B_HID_UID_CON_PROGRAMMABLE_BUTTONS,
	B_HID_UID_CON_MICROPHONE,
	B_HID_UID_CON_HEADPHONE,
	B_HID_UID_CON_GRAPHIC_EQUALIZER,
	
	B_HID_UID_CON_PLUS_10 = 0x20,
	B_HID_UID_CON_PLUS_100,
	B_HID_UID_CON_AM_PM,
	
	B_HID_UID_CON_POWER = 0x30,
	B_HID_UID_CON_RESET,
	B_HID_UID_CON_SLEEP,
	B_HID_UID_CON_SLEEP_AFTER,
	B_HID_UID_CON_SLEEP_MODE,
	B_HID_UID_CON_ILLUMINATION,
	B_HID_UID_CON_FUNCTION_BUTTONS,
	
	B_HID_UID_CON_MENU = 0x40,
	B_HID_UID_CON_MENU_PICK,
	B_HID_UID_CON_MENU_UP,
	B_HID_UID_CON_MENU_DOWN,
	B_HID_UID_CON_MENU_LEFT,
	B_HID_UID_CON_MENU_RIGHT,
	B_HID_UID_CON_MENU_ESCAPE,
	B_HID_UID_CON_MENU_VALUE_INCREASE,
	B_HID_UID_CON_MENU_VALUE_DECREASE,
	
	B_HID_UID_CON_DATA_ON_SCREEN = 0x60,
	B_HID_UID_CON_CLOSED_CAPTION,
	B_HID_UID_CON_CLOSED_CAPTION_SELECT,
	B_HID_UID_CON_VCR_TV,
	B_HID_UID_CON_BROADCAST_MODE,
	B_HID_UID_CON_SNAPSHOT,
	B_HID_UID_CON_STILL,
	
	B_HID_UID_CON_SELECTION = 0x80,
	B_HID_UID_CON_ASSIGN_SELECTION,
	B_HID_UID_CON_MODE_SETUP,
	B_HID_UID_CON_RECALL_LIST,
	B_HID_UID_CON_ENTER_CHANNEL,
	B_HID_UID_CON_ORDER_MOVIE,
	B_HID_UID_CON_CHANNEL,
	B_HID_UID_CON_MEDIA_SELECTION,
	B_HID_UID_CON_MEDIA_SELECT_COMPUTER,
	B_HID_UID_CON_MEDIA_SELECT_TV,
	B_HID_UID_CON_MEDIA_SELECT_WWW,
	B_HID_UID_CON_MEDIA_SELECT_DVD,
	B_HID_UID_CON_MEDIA_SELECT_TELEPHONE,
	B_HID_UID_CON_MEDIA_SELECT_PROGRAM_GUIDE,
	B_HID_UID_CON_MEDIA_SELECT_VIDEO_PHONE,
	B_HID_UID_CON_MEDIA_SELECT_GAMES,
	B_HID_UID_CON_MEDIA_SELECT_MESSAGES,
	B_HID_UID_CON_MEDIA_SELECT_CD,
	B_HID_UID_CON_MEDIA_SELECT_VCR,
	B_HID_UID_CON_MEDIA_SELECT_TUNER,
	B_HID_UID_CON_QUIT,
	B_HID_UID_CON_HELP,
	B_HID_UID_CON_MEDIA_SELECT_TAPE,
	B_HID_UID_CON_MEDIA_SELECT_CABLE,
	B_HID_UID_CON_MEDIA_SELECT_SATELLITE,
	B_HID_UID_CON_MEDIA_SELECT_SECURITY,
	B_HID_UID_CON_MEDIA_SELECT_HOME,
	B_HID_UID_CON_MEDIA_SELECT_CALL,
	B_HID_UID_CON_CHANNEL_INCREMENT,
	B_HID_UID_CON_CHANNEL_DECREMENT,	
	B_HID_UID_CON_MEDIA_SELECT_SAP,
	
	B_HID_UID_CON_VCR_PLUS = 0xa0,
	B_HID_UID_CON_ONCE,
	B_HID_UID_CON_DAILY,
	B_HID_UID_CON_WEEKLY,
	B_HID_UID_CON_MONTHLY,
	
	B_HID_UID_CON_PLAY = 0xb0,
	B_HID_UID_CON_PAUSE,
	B_HID_UID_CON_RECORD,
	B_HID_UID_CON_FAST_FORWARD,
	B_HID_UID_CON_REWIND,
	B_HID_UID_CON_SCAN_NEXT_TRACK,
	B_HID_UID_CON_SCAN_PREVIOUS_TRACK,
	B_HID_UID_CON_STOP,
	B_HID_UID_CON_EJECT,
	B_HID_UID_CON_RANDOM_PLAY,
	B_HID_UID_CON_SELECT_DISC,
	B_HID_UID_CON_ENTER_DISC,
	B_HID_UID_CON_REPEAT,
	B_HID_UID_CON_TRACKING,
	B_HID_UID_CON_TRACKING_NORMAL,
	B_HID_UID_CON_SLOW_TRACKING,
	B_HID_UID_CON_FRAME_FORWARD,
	B_HID_UID_CON_FRAME_BACKWARD,
	B_HID_UID_CON_MARK,
	B_HID_UID_CON_CLEAR_MARK,
	B_HID_UID_CON_REPEAT_FROM_MARK,
	B_HID_UID_CON_RETURN_TO_MARK,
	B_HID_UID_CON_SEARCH_MARK_FORWARD,
	B_HID_UID_CON_SEARCH_MARK_BACKWARDS,
	B_HID_UID_CON_COUNTER_RESET,
	B_HID_UID_CON_SHOW_COUNTER,
	B_HID_UID_CON_TRACKING_INCREMENT,
	B_HID_UID_CON_TRACKING_DECREMENT,
	B_HID_UID_CON_STOP_EJECT,
	B_HID_UID_CON_PLAY_PAUSE,
	B_HID_UID_CON_PLAY_SKIP,
	
	B_HID_UID_CON_VOLUME = 0xe0,
	B_HID_UID_CON_BALANCE,
	B_HID_UID_CON_MUTE,
	B_HID_UID_CON_BASS,
	B_HID_UID_CON_TREBLE,
	B_HID_UID_CON_BASS_BOOST,
	B_HID_UID_CON_SURROUND_MODE,
	B_HID_UID_CON_LOUDNESS,
	B_HID_UID_CON_MPX,
	B_HID_UID_CON_VOLUME_INCREMENT,
	B_HID_UID_CON_VOLUME_DECREMENT,
	
	B_HID_UID_CON_SPEED_SELECT = 0xf0,
	B_HID_UID_CON_PLAYBACK_SPEED,
	B_HID_UID_CON_STANDARD_PLAY,
	B_HID_UID_CON_LONG_PLAY,
	B_HID_UID_CON_EXTENDED_PLAY,
	B_HID_UID_CON_SLOW,
	
	B_HID_UID_CON_FAN_ENABLE = 0x100,
	B_HID_UID_CON_FAN_DISABLE,
	B_HID_UID_CON_LIGHT_ENABLE,
	B_HID_UID_CON_LIGHT_ILLUMINATION_LEVEL,
	B_HID_UID_CON_CLIMATE_CONTROL_ENABLE,
	B_HID_UID_CON_ROOM_TEMPERATURE,
	B_HID_UID_CON_SECURITY_ENABLE,
	B_HID_UID_CON_FIRE_ALARM,
	B_HID_UID_CON_POLICE_ALARM,
	B_HID_UID_CON_PROXIMITY,
	B_HID_UID_CON_MOTION,
	B_HID_UID_CON_DURESS_ALARM,
	B_HID_UID_CON_HOLDUP_ALARM,
	B_HID_UID_CON_MEDICAL_ALARM,
	
	B_HID_UID_CON_BALANCE_RIGHT = 0x150,
	B_HID_UID_CON_BALANCE_LEFT,
	B_HID_UID_CON_BASS_INCREMENT,
	B_HID_UID_CON_BASS_DECREMENT,
	B_HID_UID_CON_TREBLE_INCREMENT,
	B_HID_UID_CON_TREBLE_DECREMENT,
	
	B_HID_UID_CON_SPEAKER_SYSTEM = 0x160,
	B_HID_UID_CON_CHANNEL_LEFT,
	B_HID_UID_CON_CHANNEL_RIGHT,
	B_HID_UID_CON_CHANNEL_CENTER,
	B_HID_UID_CON_CHANNEL_FRONT,
	B_HID_UID_CON_CHANNEL_CENTER_FRONT,
	B_HID_UID_CON_CHANNEL_SIDE,
	B_HID_UID_CON_CHANNEL_SURROUND,
	B_HID_UID_CON_CHANNEL_LOW_FREQUENCE_ENHANCEMENT,
	B_HID_UID_CON_CHANNEL_TOP,
	B_HID_UID_CON_CHANNEL_UNKNOWN,
	
	B_HID_UID_CON_SUBCHANNEL = 0x170,
	B_HID_UID_CON_SUBCHANNEL_INCREMENT,
	B_HID_UID_CON_SUBCHANNEL_DECREMENT,
	B_HID_UID_CON_ALTERNATE_AUDIO_INCREMENT,
	B_HID_UID_CON_ALTERNATE_AUDIO_DECREMENT,
	
	B_HID_UID_CON_APPLICATION_LAUNCH_BUTTONS = 0x180,
	B_HID_UID_CON_AL_LAUNCH_BUTTON_CONFIGURATION_TOOL,
	B_HID_UID_CON_AL_PROGRAMMABLE_BUTTON_CONFIGURATION,
	B_HID_UID_CON_AL_CONSUMER_CONTROL_CONFIGURATION,
	B_HID_UID_CON_AL_WORD_PROCESSOR,
	B_HID_UID_CON_AL_TEXT_EDITOR,
	B_HID_UID_CON_AL_SPREADSHEET,
	B_HID_UID_CON_AL_GRAPHICS_EDITOR,
	B_HID_UID_CON_AL_PRESENTATION_APP,
	B_HID_UID_CON_AL_DATABASE_APP,
	B_HID_UID_CON_AL_EMAIL_READER,
	B_HID_UID_CON_AL_NEWSREADER,
	B_HID_UID_CON_AL_VOICEMAIL,
	B_HID_UID_CON_AL_CONTACTS_ADDRESS_BOOK,
	B_HID_UID_CON_AL_CALENDER_SCHEDULE,
	B_HID_UID_CON_AL_TASK_PROJECT_MANAGER,
	B_HID_UID_CON_AL_LOG_JOURNAL_TIMECARD,
	B_HID_UID_CON_AL_CHECKBOOK_FINANCE,
	B_HID_UID_CON_AL_CALCULATOR,
	B_HID_UID_CON_AL_AV_CAPTURE_PLAYBACK,
	B_HID_UID_CON_AL_LOCAL_MACHINE_BROWSER,
	B_HID_UID_CON_AL_LAN_WAN_BROWSER,
	B_HID_UID_CON_AL_INTERNET_BROWSER,
	B_HID_UID_CON_AL_REMOTE_NETWORKING_ISP_CONNECT,
	B_HID_UID_CON_AL_NETWORK_CONFERENCE,
	B_HID_UID_CON_AL_NETWORK_CHAT,
	B_HID_UID_CON_AL_TELEPHONY_DIALER,
	B_HID_UID_CON_AL_LOGON,
	B_HID_UID_CON_AL_LOGOFF,
	B_HID_UID_CON_AL_LOGON_LOGOFF,
	B_HID_UID_CON_AL_TERMINAL_LOCK_SCREEN,
	B_HID_UID_CON_AL_CONTROL_PANEL,
	B_HID_UID_CON_AL_COMMAND_LINE_PROCESSOR_RUN,
	B_HID_UID_CON_AL_PROCESS_TASK_MANAGER,
	B_HID_UID_CON_AL_SELECT_TASK_APPLICATION,
	B_HID_UID_CON_AL_NEXT_TASK_APPLICATION,
	B_HID_UID_CON_AL_PREVIOUS_TASK_APPLICATION,
	B_HID_UID_CON_AL_PREEMPTIVE_HALT_TASK_APPLICATION,
	B_HID_UID_CON_AL_INTERGRATED_HELP_CENTER,
	B_HID_UID_CON_AL_DOCUMENTS,
	B_HID_UID_CON_AL_THESAURUS,
	B_HID_UID_CON_AL_DICTIONARY,
	B_HID_UID_CON_AL_DESKTOP,
	B_HID_UID_CON_AL_SPELL_CHECK,
	B_HID_UID_CON_AL_GRAMMAR_CHECK,
	B_HID_UID_CON_AL_WIRELESS_STATUS,
	B_HID_UID_CON_AL_KEYBOARD_LAYOUT,
	B_HID_UID_CON_AL_VIRUS_PROTECTION,
	B_HID_UID_CON_AL_ENCRYPTION,
	B_HID_UID_CON_AL_SCREEN_SAVER,
	B_HID_UID_CON_AL_ALARMS,
	B_HID_UID_CON_AL_CLOCK,
	B_HID_UID_CON_AL_FILE_BROWSER,
	B_HID_UID_CON_AL_POWER_STATUS,
	B_HID_UID_CON_AL_IMAGE_BROWSER,
	B_HID_UID_CON_AL_AUDIO_BROWSER,
	B_HID_UID_CON_AL_MOVIE_BROWSER,
	B_HID_UID_CON_AL_DIGITAL_RIGHTS_MANAGER,
	B_HID_UID_CON_AL_DIGITAL_WALLET,
	
	B_HID_UID_CON_AL_INSTANT_MESSAGING = 0x1bc,
	B_HID_UID_CON_AL_OEM_FEATURES_TIPS_TUTORIAL_BROWSER,
	B_HID_UID_CON_AL_OEM_HELP,
	B_HID_UID_CON_AL_ONLINE_COMMUNITY,
	B_HID_UID_CON_AL_ENTERTAINMENT_CONTENT_BROWSER,
	B_HID_UID_CON_AL_ONLINE_SHOPPING_BROWSER,
	B_HID_UID_CON_AL_SMARTCARD_INFORMATION_HELP,
	B_HID_UID_CON_AL_MARKET_MONITOR_FINANCE_BROWSER,
	B_HID_UID_CON_AL_CUSTOMIZED_CORPORATE_NEWS_BROWSER,
	B_HID_UID_CON_AL_ONLINE_ACTIVITY_BROWSER,
	B_HID_UID_CON_AL_RESEARCH_SEARCH_BROWSER,
	B_HID_UID_CON_AL_AUDIO_PLAYER,
	
	B_HID_UID_CON_GENERIC_GUI_APPLICATION_CONTROLS = 0x200,
	B_HID_UID_CON_AC_NEW,
	B_HID_UID_CON_AC_OPEN,
	B_HID_UID_CON_AC_CLOSE,
	B_HID_UID_CON_AC_EXIT,
	B_HID_UID_CON_AC_MAXIMIZE,
	B_HID_UID_CON_AC_MINIMIZE,
	B_HID_UID_CON_AC_SAVE,
	B_HID_UID_CON_AC_PRINT,
	B_HID_UID_CON_AC_PROPERTIES,
	B_HID_UID_CON_AC_UNDO,
	B_HID_UID_CON_AC_COPY,
	B_HID_UID_CON_AC_CUT,
	B_HID_UID_CON_AC_PASTE,
	B_HID_UID_CON_AC_SELECT_ALL,
	B_HID_UID_CON_AC_FIND,
	B_HID_UID_CON_AC_FIND_AND_REPLACE,
	B_HID_UID_CON_AC_SEARCH,
	B_HID_UID_CON_AC_GO_TO,
	B_HID_UID_CON_AC_HOME,
	B_HID_UID_CON_AC_BACK,
	B_HID_UID_CON_AC_FORWARD,
	B_HID_UID_CON_AC_STOP,
	B_HID_UID_CON_AC_REFRESH,
	B_HID_UID_CON_AC_PREVIOUS_LINK,
	B_HID_UID_CON_AC_NEXT_LINK,
	B_HID_UID_CON_AC_BOOKMARKS,
	B_HID_UID_CON_AC_HISTORY,
	B_HID_UID_CON_AC_SUBSCRIPTIONS,
	B_HID_UID_CON_AC_ZOOM_IN,
	B_HID_UID_CON_AC_ZOOM_OUT,
	B_HID_UID_CON_AC_ZOOM,
	B_HID_UID_CON_AC_FULL_SCREEN_VIEW,
	B_HID_UID_CON_AC_NORMAL_VIEW,
	B_HID_UID_CON_AC_VIEW_TOGGLE,
	B_HID_UID_CON_AC_SCROLL_UP,
	B_HID_UID_CON_AC_SCROLL_DOWN,
	B_HID_UID_CON_AC_SCROLL,
	B_HID_UID_CON_AC_PAN_LEFT,
	B_HID_UID_CON_AC_PAN_RIGHT,
	B_HID_UID_CON_AC_PAN,
	B_HID_UID_CON_AC_NEW_WINDOW,
	B_HID_UID_CON_AC_TILE_HORIZONTALLY,
	B_HID_UID_CON_AC_TILE_VERTICALLY,
	B_HID_UID_CON_AC_FORMAT,
	B_HID_UID_CON_AC_EDIT,
	B_HID_UID_CON_AC_BOLD,
	B_HID_UID_CON_AC_ITALICS,
	B_HID_UID_CON_AC_UNDERLINE,
	B_HID_UID_CON_AC_STRIKETHROUGH,
	B_HID_UID_CON_AC_SUBSCRIPT,
	B_HID_UID_CON_AC_SUPERSCRIPT,
	B_HID_UID_CON_AC_ALL_CAPS,
	B_HID_UID_CON_AC_ROTATE,
	B_HID_UID_CON_AC_RESIZE,
	B_HID_UID_CON_AC_FLIP_HORIZONTAL,
	B_HID_UID_CON_AC_FLIP_VERTICAL,
	B_HID_UID_CON_AC_MIRROR_HORIZONTAL,
	B_HID_UID_CON_AC_MIRROR_VERTICAL,
	B_HID_UID_CON_AC_FONT_SELECT,
	B_HID_UID_CON_AC_FONT_COLOR,
	B_HID_UID_CON_AC_FONT_SIZE,
	B_HID_UID_CON_AC_JUSTIFY_LEFT,
	B_HID_UID_CON_AC_JUSTIFY_CENTER_H,
	B_HID_UID_CON_AC_JUSTIFY_RIGHT,
	B_HID_UID_CON_AC_JUSTIFY_BLOCK_H,
	B_HID_UID_CON_AC_JUSTIFY_TOP,
	B_HID_UID_CON_AC_JUSTIFY_CENTER_V,
	B_HID_UID_CON_AC_JUSTIFY_BOTTOM,
	B_HID_UID_CON_AC_JUSTIFY_BLOCK_V,
	B_HID_UID_CON_AC_INDENT_DECREASE,
	B_HID_UID_CON_AC_INDENT_INCREASE,
	B_HID_UID_CON_AC_NUMBERED_LIST,
	B_HID_UID_CON_AC_RESTART_NUMBERING,
	B_HID_UID_CON_AC_BULLETED_LIST,
	B_HID_UID_CON_AC_PROMOTE,
	B_HID_UID_CON_AC_DEMOTE,
	B_HID_UID_CON_AC_YES,
	B_HID_UID_CON_AC_NO,
	B_HID_UID_CON_AC_CANCEL,
	B_HID_UID_CON_AC_CATALOG,
	B_HID_UID_CON_AC_BUY_CHECKOUT,
	B_HID_UID_CON_AC_ADD_TO_CART,
	B_HID_UID_CON_AC_EXPAND,
	B_HID_UID_CON_AC_EXPAND_ALL,
	B_HID_UID_CON_AC_COLLAPSE,
	B_HID_UID_CON_AC_COLLAPSE_ALL,
	B_HID_UID_CON_AC_PRINT_PREVIEW,
	B_HID_UID_CON_AC_PASTE_SPECIAL,
	B_HID_UID_CON_AC_INSERT_MODE,
	B_HID_UID_CON_AC_DELETE,
	B_HID_UID_CON_AC_LOCK,
	B_HID_UID_CON_AC_UNLOCK,
	B_HID_UID_CON_AC_PROTECT,
	B_HID_UID_CON_AC_UNPROTECT,
	B_HID_UID_CON_AC_ATTACH_COMMENT,
	B_HID_UID_CON_AC_DELETE_COMMENT,
	B_HID_UID_CON_AC_VIEW_COMMENT,
	B_HID_UID_CON_AC_SELECT_WORD,
	B_HID_UID_CON_AC_SELECT_SENTENCE,
	B_HID_UID_CON_AC_SELECT_PARAGRAPH,
	B_HID_UID_CON_AC_SELECT_COLUMN,
	B_HID_UID_CON_AC_SELECT_ROW,
	B_HID_UID_CON_AC_SELECT_TABLE,
	B_HID_UID_CON_AC_SELECT_OBJECT,
	B_HID_UID_CON_AC_REDO_REPEAT,
	B_HID_UID_CON_AC_SORT,
	B_HID_UID_CON_AC_SORT_ASCENDING,
	B_HID_UID_CON_AC_SORT_DESCENDING,
	B_HID_UID_CON_AC_FILTER,
	B_HID_UID_CON_AC_SET_CLOCK,
	B_HID_UID_CON_AC_VIEW_CLOCK,
	B_HID_UID_CON_AC_SELECT_TIME_ZONE,
	B_HID_UID_CON_AC_EDIT_TIME_ZONES,
	B_HID_UID_CON_AC_SET_ALARM,
	B_HID_UID_CON_AC_CLEAR_ALARM,
	B_HID_UID_CON_AC_SNOOZE_ALARM,
	B_HID_UID_CON_AC_RESET_ALARM,
	B_HID_UID_CON_AC_SYNCHRONIZE,
	B_HID_UID_CON_AC_SEND_RECEIVE,
	B_HID_UID_CON_AC_SEND_TO,
	B_HID_UID_CON_AC_REPLY,
	B_HID_UID_CON_AC_REPLY_ALL,
	B_HID_UID_CON_AC_FORWARD_MSG,
	B_HID_UID_CON_AC_SEND,
	B_HID_UID_CON_AC_ATTACH_FILE,
	B_HID_UID_CON_AC_UPLOAD,
	B_HID_UID_CON_AC_DOWNLOAD,
	B_HID_UID_CON_AC_SET_BORDERS,
	B_HID_UID_CON_AC_INSERT_ROW,
	B_HID_UID_CON_AC_INSERT_COLUMN,
	B_HID_UID_CON_AC_INSERT_FILE,
	B_HID_UID_CON_AC_INSERT_PICTURE,
	B_HID_UID_CON_AC_INSERT_OBJECT,
	B_HID_UID_CON_AC_INSERT_SYMBOL,
	B_HID_UID_CON_AC_SAVE_AND_CLOSE,
	B_HID_UID_CON_AC_RENAME,
	B_HID_UID_CON_AC_MERGE,
	B_HID_UID_CON_AC_SPLIT,
	B_HID_UID_CON_AC_DISTRIBUTE_HORIZONTALLY,
	B_HID_UID_CON_AC_DISTRIBUTE_VERTICALLY
};


#endif // _USB_HID_PAGE_CONSUMER_H
