/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_DIGITIZERS_H
#define _USB_HID_PAGE_DIGITIZERS_H


/* Reference:
 *		HID Usage Page 0x0D: DIGITIZERS
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_DIG_DIGITIZER = 0x1,
	B_HID_UID_DIG_PEN,
	B_HID_UID_DIG_LIGHT_PEN,
	B_HID_UID_DIG_TOUCH_SCREEN,
	B_HID_UID_DIG_TOUCH_PAD,
	B_HID_UID_DIG_WHITE_BOARD,
	B_HID_UID_DIG_COORDINATE_MEASURING_MACHINE,
	B_HID_UID_DIG_3D_DIGITIZER,
	B_HID_UID_DIG_STEREO_PLOTTER,
	B_HID_UID_DIG_ARTICULATED_ARM,
	B_HID_UID_DIG_ARMATURE,
	B_HID_UID_DIG_MULTIPLE_POINT_DIGITIZER,
	B_HID_UID_DIG_FREE_SPACE_WAND,
	
	B_HID_UID_DIG_STYLUS = 0x20,
	B_HID_UID_DIG_PUCK,
	B_HID_UID_DIG_FINGER,
	
	B_HID_UID_DIG_TIP_PRESSURE = 0x30,
	B_HID_UID_DIG_BARREL_PRESSURE,
	B_HID_UID_DIG_IN_RANGE,
	B_HID_UID_DIG_TOUCH,
	B_HID_UID_DIG_UNTOUCH,
	B_HID_UID_DIG_TAP,
	B_HID_UID_DIG_QUALITY,
	B_HID_UID_DIG_DATA_VALID,
	B_HID_UID_DIG_TRANSDUCER_INDEX,
	B_HID_UID_DIG_TABLET_FUNCTION_KEYS,
	B_HID_UID_DIG_PROGRAM_CHANGE_KEYS,
	B_HID_UID_DIG_BATTERY_STRENGTH,
	B_HID_UID_DIG_INVERT,
	B_HID_UID_DIG_X_TILT,
	B_HID_UID_DIG_Y_TILT,
	B_HID_UID_DIG_AZIMUTH,
	B_HID_UID_DIG_ALTITUDE,
	B_HID_UID_DIG_TWIST,
	B_HID_UID_DIG_TIP_SWITCH,
	B_HID_UID_DIG_SECONDARY_TIP_SWITCH,
	B_HID_UID_DIG_BARREL_SWITCH,
	B_HID_UID_DIG_ERASER,
	B_HID_UID_DIG_TABLET_PICK
};


#endif // _USB_HID_PAGE_DIGITIZERS_H
