/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_GENERIC_DESKTOP_H
#define _USB_HID_PAGE_GENERIC_DESKTOP_H


/* Reference:
 *		HID Usage Page 0x01: GENERIC DESKTOP
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_GD_POINTER = 0x1,
	B_HID_UID_GD_MOUSE,
	
	B_HID_UID_GD_JOYSTICK = 0x4,
	B_HID_UID_GD_GAMEPAD,
	B_HID_UID_GD_KEYBOARD,
	B_HID_UID_GD_KEYPAD,
	B_HID_UID_GD_MULTIAXIS,
	B_HID_UID_GD_TABLET_PC_SYSTEM_CONTROLS,

	B_HID_UID_GD_X = 0x30,
	B_HID_UID_GD_Y,
	B_HID_UID_GD_Z,
	B_HID_UID_GD_RX,
	B_HID_UID_GD_RY,
	B_HID_UID_GD_RZ,
	B_HID_UID_GD_SLIDER,
	B_HID_UID_GD_DIAL,
	B_HID_UID_GD_WHEEL,
	B_HID_UID_GD_HAT_SWITCH,
	B_HID_UID_GD_COUNTED_BUFFER,
	B_HID_UID_GD_BYTE_COUNT,
	B_HID_UID_GD_MOTION_WAKEUP,
	B_HID_UID_GD_START,
	B_HID_UID_GD_SELECT,
	
	B_HID_UID_GD_VX = 0x40,
	B_HID_UID_GD_VY,
	B_HID_UID_GD_VZ,
	B_HID_UID_GD_VBRX,
	B_HID_UID_GD_VBRY,
	B_HID_UID_GD_VBRZ,
	B_HID_UID_GD_VNO,
	B_HID_UID_GD_FEATURE_NOTIFICATION,
	B_HID_UID_GD_RESOLUTION_MULTIPLIER,
	
	B_HID_UID_GD_SYSTEM_CONTROL = 0x80,
	B_HID_UID_GD_SYSTEM_POWER_DOWN,
	B_HID_UID_GD_SYSTEM_SLEEP,
	B_HID_UID_GD_SYSTEM_WAKE_UP,
	B_HID_UID_GD_SYSTEM_CONTEXT_MENU,
	B_HID_UID_GD_SYSTEM_MAIN_MENU,
	B_HID_UID_GD_SYSTEM_APP_MENU,
	B_HID_UID_GD_SYSTEM_MENU_HELP,
	B_HID_UID_GD_SYSTEM_MENU_EXIT,
	B_HID_UID_GD_SYSTEM_MENU_SELECT,
	B_HID_UID_GD_SYSTEM_MENU_RIGHT,
	B_HID_UID_GD_SYSTEM_MENU_LEFT,
	B_HID_UID_GD_SYSTEM_MENU_UP,
	B_HID_UID_GD_SYSTEM_MENU_DOWN,
	B_HID_UID_GD_SYSTEM_COLD_RESTART,
	B_HID_UID_GD_SYSTEM_WARM_RESTART,
	B_HID_UID_GD_DPAD_UP,
	B_HID_UID_GD_DPAD_DOWN,
	B_HID_UID_GD_DPAD_RIGHT,
	B_HID_UID_GD_DPAD_LEFT,
	
	B_HID_UID_GD_SYSTEM_DOCK = 0xa0,
	B_HID_UID_GD_SYSTEM_UNDOCK,
	B_HID_UID_GD_SYSTEM_SETUP,
	B_HID_UID_GD_SYSTEM_BREAK,
	B_HID_UID_GD_SYSTEM_DEBUGGER_BREAK,
	B_HID_UID_GD_APPLICATION_BREAK,
	B_HID_UID_GD_APPLICATION_DEBUGGER_BREAK,
	B_HID_UID_GD_SYSTEM_SPEAKER_MUTE,
	B_HID_UID_GD_SYSTEM_HIBERNATE,
	
	B_HID_UID_GD_SYSTEM_DISPLAY_INVERT = 0xb0,
	B_HID_UID_GD_SYSTEM_DISPLAY_INTERNAL,
	B_HID_UID_GD_SYSTEM_DISPLAY_EXTERNAL,
	B_HID_UID_GD_SYSTEM_DISPLAY_BOTH,
	B_HID_UID_GD_SYSTEM_DISPLAY_DUAL,
	B_HID_UID_GD_SYSTEM_DISPLAY_TOGGLE,
	B_HID_UID_GD_SYSTEM_DISPLAY_SWAP,
	B_HID_UID_GD_SYSTEM_DISPLAY_LCD_AUTOSCALE
};


#endif // _USB_HID_PAGE_GENERIC_DESKTOP_H
