/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_PHYSICAL_INTERFACE_DEVICE_H
#define _USB_HID_PAGE_PHYSICAL_INTERFACE_DEVICE_H


/* Reference:
 *		HID Usage Page 0x0F: PHYSICAL INTERFACE DEVICE
 *		Device Class Definition for Physical Interface Deviced (PID) Ver. 1.0
 *		http://www.usb.org/developers/devclass_docs/pid1_01.pdf
 */

// UsageIDs
enum {
	B_HID_UID_PID_PHYSICAL_INTERFACE_DEVICE = 0x01,
	
	B_HID_UID_PID_NORMAL = 0x20,
	B_HID_UID_PID_SET_EFFECT_REPORT,
	B_HID_UID_PID_EFFECT_BLOCK_INDEX,
	B_HID_UID_PID_PARAMETER_BLOCK_OFFSET,
	B_HID_UID_PID_ROM_FLAG,
	B_HID_UID_PID_EFFECT_TYPE,
	B_HID_UID_PID_ET_CONSTANT_FORCE_DATA,
	
	B_HID_UID_PID_ET_SQUARE = 0x30,
	B_HID_UID_PID_ET_SINE,
	B_HID_UID_PID_ET_TRIANGLE,
	B_HID_UID_PID_ET_SAWTOOTH_UP,
	B_HID_UID_PID_ET_SAWTOOTH_DOWN,
	
	B_HID_UID_PID_ET_SPRING,
	B_HID_UID_PID_ET_DAMPER,
	B_HID_UID_PID_ET_INERTIA,
	B_HID_UID_PID_ET_FRICTION,
	
	B_HID_UID_PID_DURATION = 0x50,
	B_HID_UID_PID_SAMPLE_PERIOD,
	B_HID_UID_PID_GAIN,
	B_HID_UID_PID_TRIGGER_BUTTON,
	B_HID_UID_PID_TRIGGER_REPEAT_INTERVAL,
	B_HID_UID_PID_AXES_ENABLE,
	B_HID_UID_PID_DIRECTION_ENABLE,
	B_HID_UID_PID_DIRECTION,
	B_HID_UID_PID_TYPE_SPECIFIC_BLOCK_OFFSET,
	B_HID_UID_PID_BLOCK_TYPE,
	B_HID_UID_PID_SET_ENVELOPE_REPORT,
	B_HID_UID_PID_ATTACK_LEVEL,
	B_HID_UID_PID_ATTACK_TIME,
	B_HID_UID_PID_FADE_LEVEL,
	B_HID_UID_PID_FADE_TIME,
	B_HID_UID_PID_SET_CONDITION_REPORT,
	B_HID_UID_PID_CP_OFFSET,
	B_HID_UID_PID_POSITIVE_COEFFICIENT,
	B_HID_UID_PID_NEGATIVE_COEFFICIENT,
	B_HID_UID_PID_POSITIVE_SATURATION,
	B_HID_UID_PID_NEGATIVE_SATURATION,
	B_HID_UID_PID_DEAD_BAND,
	B_HID_UID_PID_DOWNLOAD_FORCE_SAMPLE,
	B_HID_UID_PID_ISOCH_CUSTOM_FORCE_ENABLE,
	B_HID_UID_PID_CUSTOM_FORCE_DATA_REPORT,
	B_HID_UID_PID_CUSTOM_FORCE_DATA,
	B_HID_UID_PID_CUSTOM_FORCE_VENDOR_DEFINED_DATA,
	B_HID_UID_PID_SET_CUSTOM_FORCE_REPORT,
	B_HID_UID_PID_CUSTOM_FORCE_DATA_OFFSET,
	B_HID_UID_PID_SAMPLE_COUNT,
	B_HID_UID_PID_SET_PERIODIC_REPORT,
	B_HID_UID_PID_OFFSET,
	B_HID_UID_PID_MAGNITUDE,
	B_HID_UID_PID_PHASE,
	B_HID_UID_PID_PERIOD,
	B_HID_UID_PID_SET_CONSTANT_FORCE_REPORT,
	B_HID_UID_PID_SET_RAMP_FORCE_REPORT,
	B_HID_UID_PID_RAMP_START,
	B_HID_UID_PID_RAMP_END,
	B_HID_UID_PID_EFFECT_OPERATION_REPORT,
	B_HID_UID_PID_EFFECT_OPERATION,
	B_HID_UID_PID_OP_EFFECT_START,
	B_HID_UID_PID_OP_EFFECT_START_SOLO,
	B_HID_UID_PID_OP_EFFECT_STOP,
	B_HID_UID_PID_LOOP_COUNT,
	B_HID_UID_PID_DEVICE_GAIN_REPORT,
	B_HID_UID_PID_DEVICE_GAIN,
	B_HID_UID_PID_PID_POOL_REPORT,
	B_HID_UID_PID_RAM_POOL_SIZE,
	B_HID_UID_PID_ROM_POOL_SIZE,
	B_HID_UID_PID_ROM_EFFECT_BLOCK_COUNT,
	B_HID_UID_PID_SIMULTANEOUS_EFFECTS_MAX,
	B_HID_UID_PID_POOL_ALIGNMENT,
	B_HID_UID_PID_PID_POOL_MOVE_REPORT,
	B_HID_UID_PID_MOVE_SOURCE,
	B_HID_UID_PID_MOVE_DESTINATION,
	B_HID_UID_PID_MOVE_LENGTH,
	B_HID_UID_PID_PID_BLOCK_LOAD_REPORT,
	
	B_HID_UID_PID_BLOCK_LOAD_STATUS = 0x8b,
	B_HID_UID_PID_BLOCK_LOAD_SUCCESS,
	B_HID_UID_PID_BLOCK_LOAD_FULL,
	B_HID_UID_PID_BLOCK_LOAD_ERROR,
	B_HID_UID_PID_BLOCK_HANDLE,
	B_HID_UID_PID_PID_BLOCK_FREE_REPORT,
	B_HID_UID_PID_TYPE_SPECIFIC_BLOCK_HANDLE,
	B_HID_UID_PID_PID_STATE_REPORT,
	
	B_HID_UID_PID_PID_DEVICE_CONTROL_REPORT = 0x95,
	B_HID_UID_PID_PID_DEVICE_CONTROL,
	B_HID_UID_PID_DC_ENABLE_ACTUATORS,
	B_HID_UID_PID_DC_DISABLE_ACTUATORS,
	B_HID_UID_PID_DC_STOP_ALL_EFFECTS,
	B_HID_UID_PID_DC_DEVICE_RESET,
	B_HID_UID_PID_DC_DEVICE_PAUSE,
	B_HID_UID_PID_DC_DEVICE_CONTINUE,
	
	B_HID_UID_PID_DEVICE_PAUSED = 0x9f,
	B_HID_UID_PID_ACTUATORS_ENABLED,
	
	B_HID_UID_PID_SAFETY_SWITCH = 0xa4,
	B_HID_UID_PID_ACTUATOR_OVERRIDE_SWITCH,
	B_HID_UID_PID_ACTUATOR_POWER,
	B_HID_UID_PID_START_DELAY,
	B_HID_UID_PID_PARAMETER_BLOCK_SIZE,
	B_HID_UID_PID_DEVICE_MANAGED_POOL,
	B_HID_UID_PID_SHARED_PARAMETER_BLOCKS,
	B_HID_UID_PID_CREATE_NEW_EFFECT_REPORT,
	B_HID_UID_PID_RAM_POOL_AVAILABLE
};


#endif // _USB_HID_PAGE_PHYSICAL_INTERFACE_DEVICE_H
