/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_SIMULATION_H
#define _USB_HID_PAGE_SIMULATION_H


/* Reference:
 *		HID Usage Page 0x02: SIMULATION
 *		HID Usage Tables Ver. 1.12
 *		http://www.usb.org/developers/devclass_docs/Hut1_12.pdf
 */

// Usage IDs
enum {
	B_HID_UID_SIM_FLIGHT_SIMULATION_DEVICE = 0x1,
	B_HID_UID_SIM_AUTOMOBILE_SIMULATION_DEVICE,
	B_HID_UID_SIM_TANK_SIMULATION_DEVICE,
	B_HID_UID_SIM_SPACESHIP_SIMULATION_DEVICE,
	B_HID_UID_SIM_SUBMARINE_SIMULATION_DEVICE,
	B_HID_UID_SIM_SAILING_SIMULATION_DEVICE,
	B_HID_UID_SIM_MOTORCYCLE_SIMULATION_DEVICE,
	B_HID_UID_SIM_SPORTS_SIMULATION_DEVICE,
	B_HID_UID_SIM_AIRPLANE_SIMULATION_DEVICE,
	B_HID_UID_SIM_HELICOPTER_SIMULATION_DEVICE,
	B_HID_UID_SIM_MAGIC_CARPET_SIMULATION_DEVICE,
	B_HID_UID_SIM_BICYCLE_SIMULATION_DEVICE,
	
	B_HID_UID_SIM_FLIGHT_CONTROL_STICK = 0x20,
	B_HID_UID_SIM_FLIGHT_STICK,
	B_HID_UID_SIM_CYCLIC_CONTROL,
	B_HID_UID_SIM_CYCLIC_TRIM,
	B_HID_UID_SIM_FLIGHT_YOKE,
	B_HID_UID_SIM_TRACK_CONTROL,
	
	B_HID_UID_SIM_AILERON = 0xb0,
	B_HID_UID_SIM_AILERON_TRIM,
	B_HID_UID_SIM_ANTI_TORQUE_CONTROL,
	B_HID_UID_SIM_AUTOPILOT_ENABLE,
	B_HID_UID_SIM_CHAFF_RELEASE,
	B_HID_UID_SIM_COLLECTIVE_CONTROL,
	B_HID_UID_SIM_DIVE_BREAK,
	B_HID_UID_SIM_ELECTRONIC_COUNTERMEASURES,
	B_HID_UID_SIM_ELEVATOR,
	B_HID_UID_SIM_ELEVATOR_TRIM,
	B_HID_UID_SIM_RUDDER,
	B_HID_UID_SIM_THROTTLE,
	B_HID_UID_SIM_FLIGHT_COMMUNICATIONS,
	B_HID_UID_SIM_FLARE_RELEASE,
	B_HID_UID_SIM_LANDING_GEAR,
	B_HID_UID_SIM_TOE_BRAKE,
	
	B_HID_UID_SIM_TRIGGER = 0xc0,
	B_HID_UID_SIM_WEAPONS_ARM,
	B_HID_UID_SIM_WEAPONS_SELECT,
	B_HID_UID_SIM_WING_FLAPS,
	B_HID_UID_SIM_ACCELERATOR,
	B_HID_UID_SIM_BRAKE,
	B_HID_UID_SIM_CLUTCH,
	B_HID_UID_SIM_SHIFTER,
	B_HID_UID_SIM_STEERING,
	B_HID_UID_SIM_TURRET_DIRECTION,
	B_HID_UID_SIM_BARREL_ELEVATION,
	B_HID_UID_SIM_DIVE_PLANE,
	B_HID_UID_SIM_BALLAST,
	B_HID_UID_SIM_BICYCLE_CRANK,
	B_HID_UID_SIM_HANDLE_BARS,
	B_HID_UID_SIM_FRONT_BRAKE,
	B_HID_UID_SIM_REAR_BRAKE
};


#endif // _USB_HID_PAGE_SIMULATION_H
