/*
 * Copyright 2004-2010, Haiku Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 */
#ifndef _USB_HID_PAGE_VESA_VIRTUAL_CONTROLS_H
#define _USB_HID_PAGE_VESA_VIRTUAL_CONTROLS_H


/* Reference:
 *		HID Usage Page 0x82: VESA VIRTUAL CONTROLS
 *		USB Monitor Control Class Specification, Rev. 1.0
 *		http://www.usb.org/developers/devclass_docs/usbmon10.pdf
 */

// Usage IDs
enum {
	B_HID_UID_VVC_DEGAUSS = 0x01,
	
	B_HID_UID_VVC_BRIGHTNESS = 0x10,
	B_HID_UID_VVC_CONTRAST = 0x12,
	B_HID_UID_VVC_RED_VIDEO_GAIN = 0x16,
	B_HID_UID_VVC_GREEN_VIDEO_GAIN = 0x18,
	B_HID_UID_VVC_BLUE_VIDEO_GAIN = 0x1a,
	B_HID_UID_VVC_FOCUS = 0x1c,
	B_HID_UID_VVC_HORIZONTAL_POSITION = 0x20,
	B_HID_UID_VVC_HORIZONTAL_SIZE = 0x22,
	B_HID_UID_VVC_HORIZONTAL_PINCUSHION = 0x24,
	B_HID_UID_VVC_HORIZONTAL_PINCUSHION_BALANCE = 0x26,
	B_HID_UID_VVC_HOROZONTAL_MISCONVERGENCE = 0x28,
	B_HID_UID_VVC_HORIZONTAL_LINEARITY = 0x2a,
	B_HID_UID_VVC_HORIZONTAL_LINEARITY_BALANCE = 0x2c,
	B_HID_UID_VVC_VERTICAL_POSITION = 0x30,
	B_HID_UID_VVC_VERTICAL_SIZE = 0x32,
	B_HID_UID_VVC_VERTICAL_PINCUSHION = 0x34,
	B_HID_UID_VVC_VERTICAL_PINCUSHION_BALANCE = 0x36,
	B_HID_UID_VVC_VERTICAL_MISCONVERGENCE = 0x38,
	B_HID_UID_VVC_VERTICAL_LINEARITY = 0x3a,
	B_HID_UID_VVC_VERTICAL_LINEARITY_BALANCE = 0x3c,
	B_HID_UID_VVC_PARALLELOGRAM_DISTORTION = 0x40,
	B_HID_UID_VVC_TRAPEZOID_DISTORTION = 0x42,
	B_HID_UID_VVC_TILT = 0x44,
	B_HID_UID_VVC_TOP_CORNER_DISTORTION_CONTROL = 0x46,
	B_HID_UID_VVC_TOP_CORNER_DISTORTION_BALANCE = 0x48,
	B_HID_UID_VVC_BOTTOM_CORNER_DISTORTION_CONTROL = 0x4a,
	B_HID_UID_VVC_BOTTOM_CORNER_DISTORTION_BALANCE = 0x4c,
	B_HID_UID_VVC_HORIZONTAL_MOIRE = 0x56,
	B_HID_UID_VVC_VERTICAL_MOIRE = 0x58,
	B_HID_UID_VVC_RED_VIDEO_BLACK_LEVEL = 0x6c,
	B_HID_UID_VVC_GREEN_VIDEO_BLACK_LEVEL = 0x6e,
	B_HID_UID_VVC_BLUE_VIDEO_BLACK_LEVEL = 0x70,
	
	B_HID_UID_VVC_INPUT_LEVEL_SELECT = 0x5e,
	B_HID_UID_VVC_INPUT_SOURCE_SELECT = 0x60,
	B_HID_UID_VVC_ON_SCREEN_DISPLAY = 0xca,
	B_HID_UID_VVC_STEREO_MODE = 0xd4,
	B_HID_UID_VVC_AUTO_SIZE_CENTER = 0xa2,
	B_HID_UID_VVC_POLARITY_HORIZONTAL_SYNCHRONIZATION = 0xa4,
	B_HID_UID_VVC_POLARITY_VERTICAL_SYNCHRONIZATION = 0xa6,
	B_HID_UID_VVC_SYNCHRONIZATION_TYPE = 0xa8,
	B_HID_UID_VVC_SCREEN_ORIENTATION = 0xaa,
	B_HID_UID_VVC_HORIZONTAL_FREQUENCY = 0xac,
	B_HID_UID_VVC_VERTICAL_FREQUENCY = 0xae,
	
	B_HID_UID_VVC_SETTINGS = 0xb0
};


#endif // _USB_HID_PAGE_VESA_VIRTUAL_CONTROLS_H
