/*
 *	ASIX AX88172/AX88772/AX88178 USB 2.0 Ethernet Driver.
 *	Copyright (c) 2011 S.Zharski <imker@gmx.li>
 *	Distributed under the terms of the MIT license.
 *
 */
#ifndef _ASIX_VENDOR_REQUESTS_H_
#define _ASIX_VENDOR_REQUESTS_H_


// USB Vendor Requests used by all chip types
// For chip-spercific information look into
// corresponding AX88***Device.cpp files.
enum ASIXVendorRequests {
	READ_RXTX_SRAM		= 0x02,
	WRITE_RXTX_SRAM		= 0x03, // AX88178-772
	WRITE_RX_SRAM		= 0x03, // AX88172
	WRITE_TX_SRAM		= 0x04, // AX88172
	SW_MII_OP			= 0x06,
	READ_MII			= 0x07,
	WRITE_MII			= 0x08,
	READ_MII_OP_MODE	= 0x09, // AX88172-772
	READ_MII_STATUS		= 0x09, // AX88178
	HW_MII_OP			= 0x0A,
	READ_SROM			= 0x0B,
	WRITE_SROM			= 0x0C,
	WRITE_SROM_ENABLE	= 0x0D,
	WRITE_SROM_DISABLE	= 0x0E,
	READ_RX_CONTROL		= 0x0F,
	WRITE_RX_CONTROL	= 0x10,
	READ_IPGS			= 0x11,
	WRITE_IPGS			= 0x12, // AX88178-772
	WRITE_IPG0			= 0x12, // AX88172
	WRITE_IPG1			= 0x13, // AX88172
	WRITE_IPG2			= 0x14, // AX88172
	READ_NODEID			= 0x13, // AX88178-772
	WRITE_NODEID		= 0x14, // AX88178-772
	READ_MF_ARRAY		= 0x15,
	WRITE_MF_ARRAY		= 0x16,
	READ_TEST			= 0x17, // AX88178-772
	READ_NODEID_AX88172		= 0x17, // AX88172
	WRITE_NODEID_AX88172	= 0x18, // AX88172
	READ_PHYID			= 0x19,
	READ_MEDIUM_STATUS	= 0x1A,
	WRITE_MEDIUM_MODE	= 0x1B,
	GET_MONITOR_MODE	= 0x1C,
	SET_MONITOR_MODE	= 0x1D,
	READ_GPIOS			= 0x1E,
	WRITE_GPIOS			= 0x1F,
	WRITE_SOFT_RESET	= 0x20, // AX88178-772
	READ_PHY_SEL_STATE	= 0x21, // AX88772
	WRITE_PHY_SEL		= 0x22, // AX88772
	READ_MIIS_IF_STATE	= 0x21, // AX88178
	WRITE_MIIS_IF_STATE	= 0x22, // AX88178
	WRITE_RXCONTROL_CFG = 0x2A  // AX88772B
};


// RX Control Register bits
enum ASIXRXControl {
	RXCTL_PROMISCUOUS	= 0x0001,
	RXCTL_ALL_MULTICAT	= 0x0002,
	RXCTL_UNICAST		= 0x0004, // AX88172
	RXCTL_SEP			= 0x0004, // AX88772-178
	RXCTL_BROADCAST		= 0x0008,
	RXCTL_MULTICAST		= 0x0010,
	RXCTL_AP			= 0x0020, // AX88772-178
	RXCTL_START			= 0x0080,
	RXCTL_USB_MFB		= 0x0100  // AX88772-178
};


#endif // _ASIX_VENDOR_REQUESTS_H_

