/*
 * Copyright 2005, Axel Dörfler, axeld@pinc-software.de. All rights reserved.
 * Distributed under the terms of the MIT License.
 */


#include <SupportDefs.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


extern const char *__progname;

struct error_pair {
	status_t value;
	const char *name;
} kErrorNames[] = {
#define E(e) { e, #e }
// generated by:
// tr ' ,=\t()+' '\n\n\n\n\n\n\n' <headers/os/support/Errors.h | grep '\(^B_\|^E[A-Z0-9]\)' | sort | uniq | awk '{ print "\tE(" $1 ")," }'
	E(B_ALREADY_RUNNING),
	E(B_AMBIGUOUS_APP_LAUNCH),
	E(B_APP_ERROR_BASE),
	E(B_BAD_ADDRESS),
	E(B_BAD_DATA),
	E(B_BAD_HANDLER),
	E(B_BAD_IMAGE_ID),
	E(B_BAD_INDEX),
	E(B_BAD_MIME_SNIFFER_RULE),
	E(B_BAD_PORT_ID),
	E(B_BAD_REPLY),
	E(B_BAD_SCRIPT_SYNTAX),
	E(B_BAD_SEM_ID),
	E(B_BAD_SUBSCRIBER),
	E(B_BAD_TEAM_ID),
	E(B_BAD_THREAD_ID),
	E(B_BAD_THREAD_STATE),
	E(B_BAD_TYPE),
	E(B_BAD_VALUE),
	E(B_BUFFER_NOT_AVAILABLE),
#ifdef B_BUFFER_OVERFLOW
	E(B_BUFFER_OVERFLOW),
#endif
	E(B_BUSTED_PIPE),
	E(B_BUSY),
	E(B_CANCELED),
	E(B_CROSS_DEVICE_LINK),
	E(B_DEBUGGER_ALREADY_INSTALLED),
	E(B_DEVICE_ERROR_BASE),
	E(B_DEVICE_FULL),
#ifdef B_DEVICE_NOT_FOUND
	E(B_DEVICE_NOT_FOUND),
#endif
	E(B_DEV_BAD_DRIVE_NUM),
	E(B_DEV_BAD_PID),
	E(B_DEV_CONFIGURATION_ERROR),
	E(B_DEV_CRC_ERROR),
	E(B_DEV_DATA_OVERRUN),
	E(B_DEV_DATA_UNDERRUN),
	E(B_DEV_DISABLED_BY_USER),
	E(B_DEV_DOOR_OPEN),
	E(B_DEV_FIFO_OVERRUN),
	E(B_DEV_FIFO_UNDERRUN),
	E(B_DEV_FORMAT_ERROR),
	E(B_DEV_ID_ERROR),
	E(B_DEV_INVALID_IOCTL),
	E(B_DEV_INVALID_PIPE),
	E(B_DEV_MEDIA_CHANGED),
	E(B_DEV_MEDIA_CHANGE_REQUESTED),
	E(B_DEV_MULTIPLE_ERRORS),
	E(B_DEV_NOT_READY),
	E(B_DEV_NO_MEDIA),
	E(B_DEV_NO_MEMORY),
	E(B_DEV_PENDING),
	E(B_DEV_READ_ERROR),
	E(B_DEV_RECALIBRATE_ERROR),
	E(B_DEV_RESOURCE_CONFLICT),
	E(B_DEV_SEEK_ERROR),
	E(B_DEV_STALLED),
	E(B_DEV_TIMEOUT),
	E(B_DEV_TOO_LATE),
	E(B_DEV_UNEXPECTED_PID),
	E(B_DEV_UNREADABLE),
	E(B_DEV_WRITE_ERROR),
	E(B_DIRECTORY_NOT_EMPTY),
	E(B_DONT_DO_THAT),
	E(B_DUPLICATE_REPLY),
	E(B_ENTRY_NOT_FOUND),
	E(B_ERROR),
	E(B_ERRORS_END),
	E(B_FILE_ERROR),
	E(B_FILE_EXISTS),
	E(B_FILE_NOT_FOUND),
#ifdef B_FILE_TOO_LARGE
	E(B_FILE_TOO_LARGE),
#endif
	E(B_GENERAL_ERROR_BASE),
	E(B_INTERFACE_ERROR_BASE),
	E(B_INTERRUPTED),
	E(B_IO_ERROR),
	E(B_IS_A_DIRECTORY),
	E(B_LAST_BUFFER_ERROR),
	E(B_LAUNCH_FAILED),
	E(B_LAUNCH_FAILED_APP_IN_TRASH),
	E(B_LAUNCH_FAILED_APP_NOT_FOUND),
	E(B_LAUNCH_FAILED_EXECUTABLE),
	E(B_LAUNCH_FAILED_FILES_APP_NOT_FOUND),
	E(B_LAUNCH_FAILED_NO_PREFERRED_APP),
	E(B_LAUNCH_FAILED_NO_RESOLVE_LINK),
	E(B_LINK_LIMIT),
	E(B_MAIL_ACCESS_ERROR),
	E(B_MAIL_ERROR_BASE),
	E(B_MAIL_INVALID_MAIL),
	E(B_MAIL_NO_DAEMON),
	E(B_MAIL_NO_RECIPIENT),
	E(B_MAIL_UNKNOWN_FIELD),
	E(B_MAIL_UNKNOWN_HOST),
	E(B_MAIL_UNKNOWN_USER),
	E(B_MAIL_WRONG_PASSWORD),
	E(B_MEDIA_ERROR_BASE),
	E(B_MESSAGE_TO_SELF),
	E(B_MIDI_ERROR_BASE),
	E(B_MISMATCHED_VALUES),
	E(B_MISSING_LIBRARY),
	E(B_MISSING_SYMBOL),
	E(B_NAME_IN_USE),
	E(B_NAME_NOT_FOUND),
	E(B_NAME_TOO_LONG),
	E(B_NOT_ALLOWED),
	E(B_NOT_AN_EXECUTABLE),
	E(B_NOT_A_DIRECTORY),
	E(B_NOT_A_MESSAGE),
#ifdef B_NOT_SUPPORTED
	E(B_NOT_SUPPORTED),
#endif
	E(B_NO_ERROR),
	E(B_NO_INIT),
	E(B_NO_MEMORY),
	E(B_NO_MORE_FDS),
	E(B_NO_MORE_PORTS),
	E(B_NO_MORE_SEMS),
	E(B_NO_MORE_TEAMS),
	E(B_NO_MORE_THREADS),
	E(B_NO_PRINT_SERVER),
	E(B_OK),
	E(B_OS_ERROR_BASE),
	E(B_PARTITION_TOO_SMALL),
	E(B_PERMISSION_DENIED),
	E(B_POSIX_ERROR_BASE),
	E(B_PRINT_ERROR_BASE),
	E(B_READ_ONLY_DEVICE),
	E(B_RESOURCE_NOT_FOUND),
	E(B_RESOURCE_UNAVAILABLE),
#ifdef B_RESULT_NOT_REPRESENTABLE
	E(B_RESULT_NOT_REPRESENTABLE),
#endif
	E(B_SERVER_NOT_FOUND),
#ifdef B_SHUTDOWN_CANCELLED
	E(B_SHUTDOWN_CANCELLED),
#endif
#ifdef B_SHUTTING_DOWN
	E(B_SHUTTING_DOWN),
#endif
	E(B_STORAGE_ERROR_BASE),
	E(B_STREAM_NOT_FOUND),
	E(B_SUBSCRIBER_NOT_ENTERED),
	E(B_TIMED_OUT),
#ifdef B_TOO_MANY_ARGS
	E(B_TOO_MANY_ARGS),
#endif
	E(B_TRANSLATION_ERROR_BASE),
	E(B_UNKNOWN_MIME_TYPE),
	E(B_UNSUPPORTED),
	E(B_WOULD_BLOCK),
	E(E2BIG),
	E(EACCES),
	E(EADDRINUSE),
	E(EADDRNOTAVAIL),
	E(EAFNOSUPPORT),
	E(EAGAIN),
	E(EALREADY),
	E(EBADF),
#ifdef EBADMSG
	E(EBADMSG),
#endif
	E(EBUSY),
#ifdef ECANCELED
	E(ECANCELED),
#endif
	E(ECHILD),
	E(ECONNABORTED),
	E(ECONNREFUSED),
	E(ECONNRESET),
	E(EDEADLK),
#ifdef EDESTADDRREQ
	E(EDESTADDRREQ),
#endif
	E(EDOM),
#ifdef EDQUOT
	E(EDQUOT),
#endif
	E(EEXIST),
	E(EFAULT),
	E(EFBIG),
	E(EFPOS),
#ifdef EHOSTDOWN
	E(EHOSTDOWN),
#endif
	E(EHOSTUNREACH),
#ifdef EIDRM
	E(EIDRM),
#endif
	E(EILSEQ),
	E(EINPROGRESS),
	E(EINTR),
	E(EINVAL),
	E(EIO),
	E(EISCONN),
	E(EISDIR),
	E(ELOOP),
	E(EMFILE),
	E(EMLINK),
	E(EMSGSIZE),
#ifdef EMULTIHOP
	E(EMULTIHOP),
#endif
	E(ENAMETOOLONG),
	E(ENETDOWN),
	E(ENETRESET),
	E(ENETUNREACH),
	E(ENFILE),
	E(ENOBUFS),
#ifdef ENODATA
	E(ENODATA),
#endif
	E(ENODEV),
	E(ENOENT),
	E(ENOEXEC),
	E(ENOLCK),
#ifdef ENOLINK
	E(ENOLINK),
#endif
	E(ENOMEM),
	E(ENOMSG),
	E(ENOPROTOOPT),
	E(ENOSPC),
#ifdef ENOSR
	E(ENOSR),
#endif
#ifdef ENOSTR
	E(ENOSTR),
#endif
	E(ENOSYS),
	E(ENOTCONN),
	E(ENOTDIR),
	E(ENOTEMPTY),
	E(ENOTSOCK),
#ifdef ENOTSUP
	E(ENOTSUP),
#endif
	E(ENOTTY),
	E(ENXIO),
	E(EOPNOTSUPP),
	E(EOVERFLOW),
	E(EPERM),
	E(EPFNOSUPPORT),
	E(EPIPE),
#ifdef EPROTO
	E(EPROTO),
#endif
	E(EPROTONOSUPPORT),
	E(EPROTOTYPE),
	E(ERANGE),
	E(EROFS),
	E(ESHUTDOWN),
	E(ESIGPARM),
	E(ESPIPE),
	E(ESRCH),
	E(ESTALE),
#ifdef ETIME
	E(ETIME),
#endif
	E(ETIMEDOUT),
#ifdef ETXTBSY
	E(ETXTBSY),
#endif
	E(EWOULDBLOCK),
	E(EXDEV),
	{ 0, NULL }
};


static void
usage(void)
{
	fprintf(stderr, "usage: %s <error number>\n"
		"Prints clear text error messages for given error numbers.\n", __progname);
	exit(-1);
}


static void
print_error(char *number)
{
	char *end;
	int32 error = (int32)strtoll(number, &end, 0);
		// strtol() cuts off hex numbers that have the highest bit set

	if (end[0]) {
		// not a number, check names
		struct error_pair *p = kErrorNames;
		while (p->name && strcmp(p->name, number))
			p++;
		if (!p->name) {
			fprintf(stderr, "%s: invalid number (%s)\n", __progname, number);
			exit(1);
		}
		error = p->value;
	}

	printf("0x%lx: %s\n", error, strerror(error));
}


int
main(int argc, char *argv[])
{
	int32 i;

	if (argc < 2)
		usage();

	for (i = 1; i < argc; i++) {
		print_error(argv[i]);
	}

	return 0;
}
