/*
 *	comp_captab.c -- The names of the capabilities indexed via a hash
 *		         table for the compiler.
 *
 */

#include <ncurses_cfg.h>
#include <curses.priv.h>
#include <tic.h>
#include <term.h>

static struct name_table_entry const _nc_info_table[] =
{
	{            "bw",	   BOOLEAN,	  0,  -1 },
	{            "am",	   BOOLEAN,	  1,  -1 },
	{           "xsb",	   BOOLEAN,	  2,  -1 },
	{           "xhp",	   BOOLEAN,	  3,  -1 },
	{          "xenl",	   BOOLEAN,	  4,  -1 },
	{            "eo",	   BOOLEAN,	  5,  -1 },
	{            "gn",	   BOOLEAN,	  6,  -1 },
	{            "hc",	   BOOLEAN,	  7,  -1 },
	{            "km",	   BOOLEAN,	  8,  -1 },
	{            "hs",	   BOOLEAN,	  9,  -1 },
	{            "in",	   BOOLEAN,	 10,  -1 },
	{            "da",	   BOOLEAN,	 11,  -1 },
	{            "db",	   BOOLEAN,	 12,  -1 },
	{           "mir",	   BOOLEAN,	 13,  -1 },
	{          "msgr",	   BOOLEAN,	 14,  -1 },
	{            "os",	   BOOLEAN,	 15,  -1 },
	{         "eslok",	   BOOLEAN,	 16,  -1 },
	{            "xt",	   BOOLEAN,	 17,  -1 },
	{            "hz",	   BOOLEAN,	 18,  -1 },
	{            "ul",	   BOOLEAN,	 19,  -1 },
	{           "xon",	   BOOLEAN,	 20,  -1 },
	{          "nxon",	   BOOLEAN,	 21,  -1 },
	{          "mc5i",	   BOOLEAN,	 22,  -1 },
	{          "chts",	   BOOLEAN,	 23,  -1 },
	{         "nrrmc",	   BOOLEAN,	 24,  -1 },
	{           "npc",	   BOOLEAN,	 25,  -1 },
	{         "ndscr",	   BOOLEAN,	 26,  -1 },
	{           "ccc",	   BOOLEAN,	 27,  -1 },
	{           "bce",	   BOOLEAN,	 28,  -1 },
	{           "hls",	   BOOLEAN,	 29,  -1 },
	{          "xhpa",	   BOOLEAN,	 30,  -1 },
	{          "crxm",	   BOOLEAN,	 31,  -1 },
	{         "daisy",	   BOOLEAN,	 32,  -1 },
	{          "xvpa",	   BOOLEAN,	 33,  -1 },
	{           "sam",	   BOOLEAN,	 34,  -1 },
	{          "cpix",	   BOOLEAN,	 35,  -1 },
	{          "lpix",	   BOOLEAN,	 36,  -1 },
	{          "cols",	    NUMBER,	  0,  -1 },
	{            "it",	    NUMBER,	  1,  -1 },
	{         "lines",	    NUMBER,	  2,   6 },
	{            "lm",	    NUMBER,	  3,  -1 },
	{           "xmc",	    NUMBER,	  4,  -1 },
	{            "pb",	    NUMBER,	  5,  -1 },
	{            "vt",	    NUMBER,	  6,  -1 },
	{           "wsl",	    NUMBER,	  7,  -1 },
	{          "nlab",	    NUMBER,	  8,  -1 },
	{            "lh",	    NUMBER,	  9,  -1 },
	{            "lw",	    NUMBER,	 10,  -1 },
	{            "ma",	    NUMBER,	 11,  -1 },
	{          "wnum",	    NUMBER,	 12,  -1 },
	{        "colors",	    NUMBER,	 13,  -1 },
	{         "pairs",	    NUMBER,	 14,  -1 },
	{           "ncv",	    NUMBER,	 15,  -1 },
	{         "bufsz",	    NUMBER,	 16,  46 },
	{         "spinv",	    NUMBER,	 17,  -1 },
	{         "spinh",	    NUMBER,	 18,  -1 },
	{         "maddr",	    NUMBER,	 19,  -1 },
	{         "mjump",	    NUMBER,	 20,  -1 },
	{           "mcs",	    NUMBER,	 21,  -1 },
	{           "mls",	    NUMBER,	 22,  -1 },
	{         "npins",	    NUMBER,	 23,  -1 },
	{           "orc",	    NUMBER,	 24,  -1 },
	{           "orl",	    NUMBER,	 25,  -1 },
	{          "orhi",	    NUMBER,	 26,  -1 },
	{          "orvi",	    NUMBER,	 27,  -1 },
	{           "cps",	    NUMBER,	 28,  -1 },
	{         "widcs",	    NUMBER,	 29,  -1 },
	{          "btns",	    NUMBER,	 30,  -1 },
	{        "bitwin",	    NUMBER,	 31,  -1 },
	{        "bitype",	    NUMBER,	 32,  68 },
	{           "cbt",	    STRING,	  0,  -1 },
	{           "bel",	    STRING,	  1,  -1 },
	{            "cr",	    STRING,	  2,  -1 },
	{           "csr",	    STRING,	  3,  -1 },
	{           "tbc",	    STRING,	  4,  -1 },
	{         "clear",	    STRING,	  5,  -1 },
	{            "el",	    STRING,	  6,  -1 },
	{            "ed",	    STRING,	  7,  -1 },
	{           "hpa",	    STRING,	  8,  -1 },
	{         "cmdch",	    STRING,	  9,  -1 },
	{           "cup",	    STRING,	 10,  73 },
	{          "cud1",	    STRING,	 11,  -1 },
	{          "home",	    STRING,	 12,  -1 },
	{         "civis",	    STRING,	 13,  -1 },
	{          "cub1",	    STRING,	 14,  -1 },
	{         "mrcup",	    STRING,	 15,  -1 },
	{         "cnorm",	    STRING,	 16,  -1 },
	{          "cuf1",	    STRING,	 17,  -1 },
	{            "ll",	    STRING,	 18,  -1 },
	{          "cuu1",	    STRING,	 19,  -1 },
	{         "cvvis",	    STRING,	 20,  -1 },
	{          "dch1",	    STRING,	 21,  -1 },
	{           "dl1",	    STRING,	 22,  -1 },
	{           "dsl",	    STRING,	 23,  -1 },
	{            "hd",	    STRING,	 24,  -1 },
	{         "smacs",	    STRING,	 25,  -1 },
	{         "blink",	    STRING,	 26,  -1 },
	{          "bold",	    STRING,	 27,  -1 },
	{         "smcup",	    STRING,	 28,  -1 },
	{          "smdc",	    STRING,	 29,  -1 },
	{           "dim",	    STRING,	 30,  -1 },
	{          "smir",	    STRING,	 31,  -1 },
	{         "invis",	    STRING,	 32,  -1 },
	{          "prot",	    STRING,	 33,  -1 },
	{           "rev",	    STRING,	 34,  -1 },
	{          "smso",	    STRING,	 35,  -1 },
	{          "smul",	    STRING,	 36,  -1 },
	{           "ech",	    STRING,	 37,  -1 },
	{         "rmacs",	    STRING,	 38,  -1 },
	{          "sgr0",	    STRING,	 39,  -1 },
	{         "rmcup",	    STRING,	 40,  -1 },
	{          "rmdc",	    STRING,	 41,  -1 },
	{          "rmir",	    STRING,	 42,  -1 },
	{          "rmso",	    STRING,	 43,  -1 },
	{          "rmul",	    STRING,	 44,  -1 },
	{         "flash",	    STRING,	 45,  -1 },
	{            "ff",	    STRING,	 46,  -1 },
	{           "fsl",	    STRING,	 47,  -1 },
	{           "is1",	    STRING,	 48,  -1 },
	{           "is2",	    STRING,	 49,  59 },
	{           "is3",	    STRING,	 50,  76 },
	{            "if",	    STRING,	 51,  -1 },
	{          "ich1",	    STRING,	 52,  20 },
	{           "il1",	    STRING,	 53,  -1 },
	{            "ip",	    STRING,	 54,  -1 },
	{           "kbs",	    STRING,	 55,  -1 },
	{          "ktbc",	    STRING,	 56,  -1 },
	{          "kclr",	    STRING,	 57,  98 },
	{         "kctab",	    STRING,	 58,  -1 },
	{         "kdch1",	    STRING,	 59,  -1 },
	{          "kdl1",	    STRING,	 60,  -1 },
	{         "kcud1",	    STRING,	 61,  -1 },
	{         "krmir",	    STRING,	 62,  -1 },
	{           "kel",	    STRING,	 63,  -1 },
	{           "ked",	    STRING,	 64,  -1 },
	{           "kf0",	    STRING,	 65,  -1 },
	{           "kf1",	    STRING,	 66,  -1 },
	{          "kf10",	    STRING,	 67,  -1 },
	{           "kf2",	    STRING,	 68,  -1 },
	{           "kf3",	    STRING,	 69,  -1 },
	{           "kf4",	    STRING,	 70,  -1 },
	{           "kf5",	    STRING,	 71,  61 },
	{           "kf6",	    STRING,	 72,  -1 },
	{           "kf7",	    STRING,	 73,  -1 },
	{           "kf8",	    STRING,	 74,  -1 },
	{           "kf9",	    STRING,	 75,  -1 },
	{         "khome",	    STRING,	 76,  -1 },
	{         "kich1",	    STRING,	 77,  -1 },
	{          "kil1",	    STRING,	 78,  -1 },
	{         "kcub1",	    STRING,	 79,  -1 },
	{           "kll",	    STRING,	 80,  -1 },
	{           "knp",	    STRING,	 81,  -1 },
	{           "kpp",	    STRING,	 82,  -1 },
	{         "kcuf1",	    STRING,	 83,  -1 },
	{          "kind",	    STRING,	 84,  55 },
	{           "kri",	    STRING,	 85, 105 },
	{          "khts",	    STRING,	 86,  -1 },
	{         "kcuu1",	    STRING,	 87,  81 },
	{          "rmkx",	    STRING,	 88,  -1 },
	{          "smkx",	    STRING,	 89,  -1 },
	{           "lf0",	    STRING,	 90,  -1 },
	{           "lf1",	    STRING,	 91,  -1 },
	{          "lf10",	    STRING,	 92,  -1 },
	{           "lf2",	    STRING,	 93,  -1 },
	{           "lf3",	    STRING,	 94,  33 },
	{           "lf4",	    STRING,	 95,  -1 },
	{           "lf5",	    STRING,	 96,  -1 },
	{           "lf6",	    STRING,	 97,  -1 },
	{           "lf7",	    STRING,	 98,   7 },
	{           "lf8",	    STRING,	 99,  94 },
	{           "lf9",	    STRING,	100,  -1 },
	{           "rmm",	    STRING,	101, 131 },
	{           "smm",	    STRING,	102,  -1 },
	{           "nel",	    STRING,	103,  -1 },
	{           "pad",	    STRING,	104,  30 },
	{           "dch",	    STRING,	105,  -1 },
	{            "dl",	    STRING,	106,  -1 },
	{           "cud",	    STRING,	107,  -1 },
	{           "ich",	    STRING,	108,  -1 },
	{          "indn",	    STRING,	109,  -1 },
	{            "il",	    STRING,	110,  -1 },
	{           "cub",	    STRING,	111,  -1 },
	{           "cuf",	    STRING,	112, 156 },
	{           "rin",	    STRING,	113,  -1 },
	{           "cuu",	    STRING,	114,  -1 },
	{         "pfkey",	    STRING,	115,  51 },
	{         "pfloc",	    STRING,	116,  -1 },
	{           "pfx",	    STRING,	117,  -1 },
	{           "mc0",	    STRING,	118,  -1 },
	{           "mc4",	    STRING,	119,  -1 },
	{           "mc5",	    STRING,	120,  -1 },
	{           "rep",	    STRING,	121,  -1 },
	{           "rs1",	    STRING,	122,  -1 },
	{           "rs2",	    STRING,	123,  -1 },
	{           "rs3",	    STRING,	124, 126 },
	{            "rf",	    STRING,	125,  -1 },
	{            "rc",	    STRING,	126,  -1 },
	{           "vpa",	    STRING,	127,  -1 },
	{            "sc",	    STRING,	128,  -1 },
	{           "ind",	    STRING,	129,  -1 },
	{            "ri",	    STRING,	130,  -1 },
	{           "sgr",	    STRING,	131,  -1 },
	{           "hts",	    STRING,	132,  -1 },
	{          "wind",	    STRING,	133,  -1 },
	{            "ht",	    STRING,	134,  -1 },
	{           "tsl",	    STRING,	135,  -1 },
	{            "uc",	    STRING,	136,  23 },
	{            "hu",	    STRING,	137,  -1 },
	{         "iprog",	    STRING,	138,  -1 },
	{           "ka1",	    STRING,	139,  -1 },
	{           "ka3",	    STRING,	140,  -1 },
	{           "kb2",	    STRING,	141, 210 },
	{           "kc1",	    STRING,	142, 211 },
	{           "kc3",	    STRING,	143, 135 },
	{          "mc5p",	    STRING,	144,  -1 },
	{           "rmp",	    STRING,	145,  -1 },
	{          "acsc",	    STRING,	146, 176 },
	{           "pln",	    STRING,	147,  -1 },
	{          "kcbt",	    STRING,	148, 194 },
	{         "smxon",	    STRING,	149,  -1 },
	{         "rmxon",	    STRING,	150,  -1 },
	{          "smam",	    STRING,	151, 137 },
	{          "rmam",	    STRING,	152,  -1 },
	{          "xonc",	    STRING,	153,  -1 },
	{         "xoffc",	    STRING,	154,  -1 },
	{         "enacs",	    STRING,	155,  -1 },
	{          "smln",	    STRING,	156,  -1 },
	{          "rmln",	    STRING,	157,  -1 },
	{          "kbeg",	    STRING,	158,  -1 },
	{          "kcan",	    STRING,	159,  -1 },
	{          "kclo",	    STRING,	160,  -1 },
	{          "kcmd",	    STRING,	161,  -1 },
	{          "kcpy",	    STRING,	162,  -1 },
	{          "kcrt",	    STRING,	163,  54 },
	{          "kend",	    STRING,	164, 192 },
	{          "kent",	    STRING,	165,  -1 },
	{          "kext",	    STRING,	166,  -1 },
	{          "kfnd",	    STRING,	167, 193 },
	{          "khlp",	    STRING,	168,  -1 },
	{          "kmrk",	    STRING,	169,  70 },
	{          "kmsg",	    STRING,	170, 235 },
	{          "kmov",	    STRING,	171,  -1 },
	{          "knxt",	    STRING,	172,  -1 },
	{          "kopn",	    STRING,	173, 177 },
	{          "kopt",	    STRING,	174,  -1 },
	{          "kprv",	    STRING,	175,  -1 },
	{          "kprt",	    STRING,	176,  -1 },
	{          "krdo",	    STRING,	177,  -1 },
	{          "kref",	    STRING,	178,  -1 },
	{          "krfr",	    STRING,	179, 239 },
	{          "krpl",	    STRING,	180, 219 },
	{          "krst",	    STRING,	181,  80 },
	{          "kres",	    STRING,	182, 249 },
	{          "ksav",	    STRING,	183, 252 },
	{          "kspd",	    STRING,	184, 240 },
	{          "kund",	    STRING,	185, 254 },
	{          "kBEG",	    STRING,	186,  -1 },
	{          "kCAN",	    STRING,	187,  -1 },
	{          "kCMD",	    STRING,	188, 101 },
	{          "kCPY",	    STRING,	189,  -1 },
	{          "kCRT",	    STRING,	190,  -1 },
	{           "kDC",	    STRING,	191,  -1 },
	{           "kDL",	    STRING,	192,  -1 },
	{          "kslt",	    STRING,	193, 244 },
	{          "kEND",	    STRING,	194,  -1 },
	{          "kEOL",	    STRING,	195, 152 },
	{          "kEXT",	    STRING,	196,  -1 },
	{          "kFND",	    STRING,	197, 150 },
	{          "kHLP",	    STRING,	198,  -1 },
	{          "kHOM",	    STRING,	199, 268 },
	{           "kIC",	    STRING,	200,  -1 },
	{          "kLFT",	    STRING,	201,  72 },
	{          "kMSG",	    STRING,	202,  -1 },
	{          "kMOV",	    STRING,	203,  -1 },
	{          "kNXT",	    STRING,	204,  -1 },
	{          "kOPT",	    STRING,	205,  -1 },
	{          "kPRV",	    STRING,	206,  -1 },
	{          "kPRT",	    STRING,	207, 196 },
	{          "kRDO",	    STRING,	208,  -1 },
	{          "kRPL",	    STRING,	209,  -1 },
	{          "kRIT",	    STRING,	210,  -1 },
	{          "kRES",	    STRING,	211,  -1 },
	{          "kSAV",	    STRING,	212, 281 },
	{          "kSPD",	    STRING,	213, 272 },
	{          "kUND",	    STRING,	214, 283 },
	{           "rfi",	    STRING,	215,  -1 },
	{          "kf11",	    STRING,	216,  -1 },
	{          "kf12",	    STRING,	217, 134 },
	{          "kf13",	    STRING,	218,  -1 },
	{          "kf14",	    STRING,	219,  -1 },
	{          "kf15",	    STRING,	220,  -1 },
	{          "kf16",	    STRING,	221,  43 },
	{          "kf17",	    STRING,	222, 256 },
	{          "kf18",	    STRING,	223,  -1 },
	{          "kf19",	    STRING,	224,  -1 },
	{          "kf20",	    STRING,	225, 286 },
	{          "kf21",	    STRING,	226, 287 },
	{          "kf22",	    STRING,	227, 288 },
	{          "kf23",	    STRING,	228, 289 },
	{          "kf24",	    STRING,	229, 290 },
	{          "kf25",	    STRING,	230, 291 },
	{          "kf26",	    STRING,	231, 292 },
	{          "kf27",	    STRING,	232, 293 },
	{          "kf28",	    STRING,	233, 294 },
	{          "kf29",	    STRING,	234, 133 },
	{          "kf30",	    STRING,	235, 296 },
	{          "kf31",	    STRING,	236, 297 },
	{          "kf32",	    STRING,	237, 298 },
	{          "kf33",	    STRING,	238, 299 },
	{          "kf34",	    STRING,	239, 300 },
	{          "kf35",	    STRING,	240, 301 },
	{          "kf36",	    STRING,	241, 302 },
	{          "kf37",	    STRING,	242, 303 },
	{          "kf38",	    STRING,	243, 304 },
	{          "kf39",	    STRING,	244, 257 },
	{          "kf40",	    STRING,	245, 306 },
	{          "kf41",	    STRING,	246, 307 },
	{          "kf42",	    STRING,	247, 308 },
	{          "kf43",	    STRING,	248, 309 },
	{          "kf44",	    STRING,	249, 310 },
	{          "kf45",	    STRING,	250, 311 },
	{          "kf46",	    STRING,	251, 312 },
	{          "kf47",	    STRING,	252, 313 },
	{          "kf48",	    STRING,	253, 314 },
	{          "kf49",	    STRING,	254, 226 },
	{          "kf50",	    STRING,	255, 316 },
	{          "kf51",	    STRING,	256, 317 },
	{          "kf52",	    STRING,	257, 318 },
	{          "kf53",	    STRING,	258, 319 },
	{          "kf54",	    STRING,	259, 320 },
	{          "kf55",	    STRING,	260, 321 },
	{          "kf56",	    STRING,	261, 322 },
	{          "kf57",	    STRING,	262, 323 },
	{          "kf58",	    STRING,	263, 324 },
	{          "kf59",	    STRING,	264, 258 },
	{          "kf60",	    STRING,	265, 326 },
	{          "kf61",	    STRING,	266, 327 },
	{          "kf62",	    STRING,	267, 328 },
	{          "kf63",	    STRING,	268, 329 },
	{           "el1",	    STRING,	269,  -1 },
	{           "mgc",	    STRING,	270,  -1 },
	{          "smgl",	    STRING,	271, 335 },
	{          "smgr",	    STRING,	272, 332 },
	{           "fln",	    STRING,	273,  -1 },
	{          "sclk",	    STRING,	274,  -1 },
	{          "dclk",	    STRING,	275,  -1 },
	{         "rmclk",	    STRING,	276,  -1 },
	{          "cwin",	    STRING,	277,  37 },
	{         "wingo",	    STRING,	278,  -1 },
	{           "hup",	    STRING,	279,  -1 },
	{          "dial",	    STRING,	280,  -1 },
	{         "qdial",	    STRING,	281,  -1 },
	{          "tone",	    STRING,	282,  -1 },
	{         "pulse",	    STRING,	283,  -1 },
	{          "hook",	    STRING,	284,  -1 },
	{         "pause",	    STRING,	285,   8 },
	{          "wait",	    STRING,	286, 262 },
	{            "u0",	    STRING,	287,  -1 },
	{            "u1",	    STRING,	288,  -1 },
	{            "u2",	    STRING,	289,  -1 },
	{            "u3",	    STRING,	290,  -1 },
	{            "u4",	    STRING,	291,  -1 },
	{            "u5",	    STRING,	292,  -1 },
	{            "u6",	    STRING,	293,  -1 },
	{            "u7",	    STRING,	294,  -1 },
	{            "u8",	    STRING,	295,  -1 },
	{            "u9",	    STRING,	296,  -1 },
	{            "op",	    STRING,	297,  -1 },
	{            "oc",	    STRING,	298,  -1 },
	{         "initc",	    STRING,	299,  -1 },
	{         "initp",	    STRING,	300,  -1 },
	{           "scp",	    STRING,	301,  -1 },
	{          "setf",	    STRING,	302, 325 },
	{          "setb",	    STRING,	303, 221 },
	{           "cpi",	    STRING,	304, 243 },
	{           "lpi",	    STRING,	305,  -1 },
	{           "chr",	    STRING,	306, 250 },
	{           "cvr",	    STRING,	307,  -1 },
	{          "defc",	    STRING,	308, 141 },
	{         "swidm",	    STRING,	309, 248 },
	{         "sdrfq",	    STRING,	310, 218 },
	{          "sitm",	    STRING,	311,  -1 },
	{           "slm",	    STRING,	312, 201 },
	{         "smicm",	    STRING,	313, 229 },
	{          "snlq",	    STRING,	314, 264 },
	{         "snrmq",	    STRING,	315, 253 },
	{          "sshm",	    STRING,	316, 334 },
	{         "ssubm",	    STRING,	317,  -1 },
	{         "ssupm",	    STRING,	318, 236 },
	{           "sum",	    STRING,	319, 185 },
	{         "rwidm",	    STRING,	320,  -1 },
	{          "ritm",	    STRING,	321,  -1 },
	{           "rlm",	    STRING,	322,  -1 },
	{         "rmicm",	    STRING,	323,  -1 },
	{          "rshm",	    STRING,	324, 112 },
	{         "rsubm",	    STRING,	325,  -1 },
	{         "rsupm",	    STRING,	326,  -1 },
	{           "rum",	    STRING,	327,  -1 },
	{          "mhpa",	    STRING,	328,  -1 },
	{         "mcud1",	    STRING,	329,  -1 },
	{         "mcub1",	    STRING,	330,  -1 },
	{         "mcuf1",	    STRING,	331,  53 },
	{          "mvpa",	    STRING,	332,  -1 },
	{         "mcuu1",	    STRING,	333,  47 },
	{        "porder",	    STRING,	334, 155 },
	{          "mcud",	    STRING,	335,  -1 },
	{          "mcub",	    STRING,	336,  -1 },
	{          "mcuf",	    STRING,	337,  -1 },
	{          "mcuu",	    STRING,	338,  -1 },
	{           "scs",	    STRING,	339,  -1 },
	{          "smgb",	    STRING,	340,  -1 },
	{         "smgbp",	    STRING,	341, 383 },
	{         "smglp",	    STRING,	342,  -1 },
	{         "smgrp",	    STRING,	343,  -1 },
	{          "smgt",	    STRING,	344, 386 },
	{         "smgtp",	    STRING,	345, 238 },
	{          "sbim",	    STRING,	346,  -1 },
	{          "scsd",	    STRING,	347, 344 },
	{          "rbim",	    STRING,	348,  31 },
	{          "rcsd",	    STRING,	349,  -1 },
	{         "subcs",	    STRING,	350, 380 },
	{         "supcs",	    STRING,	351, 255 },
	{          "docr",	    STRING,	352,  -1 },
	{         "zerom",	    STRING,	353,  -1 },
	{          "csnm",	    STRING,	354, 347 },
	{         "kmous",	    STRING,	355,  -1 },
	{         "minfo",	    STRING,	356,  -1 },
	{         "reqmp",	    STRING,	357,  -1 },
	{          "getm",	    STRING,	358,  87 },
	{         "setaf",	    STRING,	359,  -1 },
	{         "setab",	    STRING,	360,  -1 },
	{          "pfxl",	    STRING,	361,  -1 },
	{          "devt",	    STRING,	362,  -1 },
	{          "csin",	    STRING,	363,  -1 },
	{          "s0ds",	    STRING,	364,  -1 },
	{          "s1ds",	    STRING,	365, 212 },
	{          "s2ds",	    STRING,	366, 109 },
	{          "s3ds",	    STRING,	367, 213 },
	{         "smglr",	    STRING,	368, 230 },
	{         "smgtb",	    STRING,	369,  -1 },
	{         "birep",	    STRING,	370,  -1 },
	{         "binel",	    STRING,	371,  -1 },
	{          "bicr",	    STRING,	372,  -1 },
	{       "colornm",	    STRING,	373,  -1 },
	{         "defbi",	    STRING,	374,  -1 },
	{         "endbi",	    STRING,	375,  -1 },
	{      "setcolor",	    STRING,	376,  -1 },
	{        "slines",	    STRING,	377, 116 },
	{         "dispc",	    STRING,	378,  -1 },
	{         "smpch",	    STRING,	379, 231 },
	{         "rmpch",	    STRING,	380,  -1 },
	{          "smsc",	    STRING,	381, 338 },
	{          "rmsc",	    STRING,	382,  -1 },
	{         "pctrm",	    STRING,	383,  -1 },
	{         "scesc",	    STRING,	384, 197 },
	{         "scesa",	    STRING,	385, 430 },
	{         "ehhlm",	    STRING,	386,  -1 },
	{         "elhlm",	    STRING,	387,  -1 },
	{        "elohlm",	    STRING,	388,  -1 },
	{         "erhlm",	    STRING,	389,  -1 },
	{         "ethlm",	    STRING,	390,  -1 },
	{         "evhlm",	    STRING,	391,  -1 },
	{          "sgr1",	    STRING,	392, 437 },
	{       "slength",	    STRING,	393,  -1 },
	{          "OTi2",	    STRING,	394,  -1 },
	{          "OTrs",	    STRING,	395,  -1 },
	{          "OTug",	    NUMBER,	 33,  -1 },
	{          "OTbs",	   BOOLEAN,	 37,  -1 },
	{          "OTns",	   BOOLEAN,	 38,  -1 },
	{          "OTnc",	   BOOLEAN,	 39,  -1 },
	{          "OTdC",	    NUMBER,	 34,  -1 },
	{          "OTdN",	    NUMBER,	 35,  -1 },
	{          "OTnl",	    STRING,	396,  -1 },
	{          "OTbc",	    STRING,	397,  13 },
	{          "OTMT",	   BOOLEAN,	 40,  -1 },
	{          "OTNL",	   BOOLEAN,	 41, 446 },
	{          "OTdB",	    NUMBER,	 36,  -1 },
	{          "OTdT",	    NUMBER,	 37,  -1 },
	{          "OTkn",	    NUMBER,	 38,  -1 },
	{          "OTko",	    STRING,	398, 472 },
	{          "OTma",	    STRING,	399,  -1 },
	{          "OTpt",	   BOOLEAN,	 42,  -1 },
	{          "OTxr",	   BOOLEAN,	 43,  -1 },
	{          "OTG2",	    STRING,	400,  -1 },
	{          "OTG3",	    STRING,	401,  -1 },
	{          "OTG1",	    STRING,	402,  -1 },
	{          "OTG4",	    STRING,	403,  -1 },
	{          "OTGR",	    STRING,	404,  -1 },
	{          "OTGL",	    STRING,	405,  -1 },
	{          "OTGU",	    STRING,	406,  -1 },
	{          "OTGD",	    STRING,	407,  -1 },
	{          "OTGH",	    STRING,	408,  26 },
	{          "OTGV",	    STRING,	409,  60 },
	{          "OTGC",	    STRING,	410, 121 },
	{          "meml",	    STRING,	411, 407 },
	{          "memu",	    STRING,	412, 402 },
	{          "box1",	    STRING,	413,  -1 } 
};

const struct name_table_entry * const _nc_info_hash_table[995] =
{
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 465,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 261,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 457,
	0,
	0,
	_nc_info_table + 265,
	_nc_info_table + 216,
	_nc_info_table + 120,
	0,
	0,
	0,
	_nc_info_table + 180,
	0,
	0,
	_nc_info_table +  88,
	0,
	_nc_info_table + 420,
	0,
	_nc_info_table + 398,
	0,
	_nc_info_table + 348,
	0,
	0,
	_nc_info_table +  19,
	0,
	0,
	0,
	_nc_info_table + 359,
	0,
	_nc_info_table + 174,
	0,
	_nc_info_table + 245,
	0,
	_nc_info_table +  74,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 269,
	0,
	_nc_info_table + 480,
	0,
	0,
	0,
	_nc_info_table + 124,
	0,
	0,
	0,
	_nc_info_table + 390,
	_nc_info_table + 379,
	_nc_info_table + 367,
	0,
	0,
	_nc_info_table + 444,
	0,
	0,
	0,
	_nc_info_table + 305,
	0,
	0,
	_nc_info_table + 363,
	0,
	0,
	_nc_info_table + 483,
	_nc_info_table + 377,
	0,
	0,
	0,
	0,
	_nc_info_table + 460,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 204,
	_nc_info_table +  38,
	0,
	_nc_info_table +  82,
	0,
	_nc_info_table + 110,
	_nc_info_table + 127,
	0,
	0,
	_nc_info_table + 463,
	0,
	0,
	0,
	0,
	_nc_info_table + 336,
	0,
	_nc_info_table +  17,
	_nc_info_table + 128,
	_nc_info_table + 434,
	0,
	_nc_info_table + 188,
	_nc_info_table + 129,
	0,
	_nc_info_table + 351,
	0,
	0,
	_nc_info_table +  16,
	0,
	0,
	_nc_info_table + 259,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 489,
	0,
	_nc_info_table + 353,
	0,
	_nc_info_table +  71,
	_nc_info_table + 247,
	0,
	0,
	0,
	0,
	_nc_info_table +  78,
	0,
	0,
	_nc_info_table + 331,
	0,
	0,
	_nc_info_table + 173,
	_nc_info_table + 136,
	_nc_info_table + 161,
	_nc_info_table + 189,
	0,
	0,
	0,
	0,
	_nc_info_table + 454,
	0,
	0,
	0,
	0,
	_nc_info_table + 224,
	_nc_info_table + 479,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 354,
	0,
	0,
	_nc_info_table + 233,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 125,
	_nc_info_table +  11,
	0,
	0,
	_nc_info_table + 378,
	_nc_info_table + 166,
	0,
	_nc_info_table + 191,
	0,
	0,
	_nc_info_table +  48,
	_nc_info_table + 228,
	0,
	_nc_info_table +   2,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 374,
	0,
	_nc_info_table + 408,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 375,
	0,
	_nc_info_table +  52,
	_nc_info_table + 145,
	_nc_info_table + 170,
	0,
	_nc_info_table + 392,
	_nc_info_table + 382,
	0,
	_nc_info_table + 393,
	_nc_info_table + 411,
	0,
	0,
	0,
	_nc_info_table + 276,
	0,
	0,
	_nc_info_table +  35,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 396,
	_nc_info_table + 388,
	_nc_info_table +  36,
	0,
	0,
	_nc_info_table +  64,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 350,
	0,
	0,
	_nc_info_table + 215,
	_nc_info_table +  91,
	0,
	0,
	_nc_info_table + 439,
	0,
	_nc_info_table + 122,
	0,
	_nc_info_table + 200,
	0,
	_nc_info_table +  67,
	0,
	_nc_info_table + 410,
	0,
	0,
	_nc_info_table +  89,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table +  96,
	_nc_info_table +  21,
	0,
	_nc_info_table + 103,
	_nc_info_table +   1,
	0,
	0,
	_nc_info_table + 369,
	0,
	0,
	_nc_info_table + 345,
	0,
	0,
	0,
	_nc_info_table + 355,
	_nc_info_table +  40,
	0,
	_nc_info_table +  27,
	0,
	_nc_info_table + 406,
	0,
	0,
	0,
	_nc_info_table + 482,
	_nc_info_table + 419,
	_nc_info_table + 417,
	0,
	0,
	_nc_info_table + 360,
	_nc_info_table + 270,
	0,
	0,
	_nc_info_table + 251,
	0,
	0,
	0,
	0,
	_nc_info_table + 349,
	0,
	0,
	_nc_info_table + 278,
	0,
	_nc_info_table + 442,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 438,
	0,
	_nc_info_table + 494,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 315,
	0,
	_nc_info_table + 340,
	_nc_info_table + 364,
	_nc_info_table + 356,
	0,
	_nc_info_table + 484,
	0,
	0,
	0,
	0,
	_nc_info_table +  32,
	0,
	0,
	0,
	_nc_info_table + 260,
	0,
	0,
	0,
	0,
	_nc_info_table + 207,
	_nc_info_table + 487,
	_nc_info_table +  84,
	_nc_info_table + 453,
	0,
	0,
	_nc_info_table + 413,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 214,
	0,
	_nc_info_table + 337,
	_nc_info_table + 352,
	_nc_info_table + 477,
	0,
	_nc_info_table + 435,
	_nc_info_table +  56,
	0,
	0,
	_nc_info_table +  34,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 132,
	0,
	_nc_info_table +  85,
	_nc_info_table + 492,
	_nc_info_table + 428,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 199,
	0,
	_nc_info_table + 342,
	0,
	0,
	0,
	_nc_info_table + 138,
	_nc_info_table + 163,
	_nc_info_table + 190,
	_nc_info_table + 147,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 266,
	0,
	0,
	_nc_info_table + 433,
	0,
	0,
	_nc_info_table + 474,
	0,
	0,
	0,
	0,
	_nc_info_table + 385,
	_nc_info_table + 100,
	0,
	0,
	0,
	_nc_info_table + 431,
	0,
	_nc_info_table + 391,
	_nc_info_table + 381,
	_nc_info_table +  12,
	_nc_info_table +  58,
	0,
	_nc_info_table + 142,
	_nc_info_table + 167,
	0,
	0,
	_nc_info_table + 409,
	0,
	0,
	0,
	0,
	_nc_info_table +  42,
	_nc_info_table +  45,
	_nc_info_table +  66,
	0,
	0,
	_nc_info_table + 424,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 220,
	_nc_info_table + 376,
	0,
	0,
	_nc_info_table + 343,
	0,
	0,
	0,
	_nc_info_table + 114,
	_nc_info_table + 106,
	0,
	0,
	_nc_info_table + 447,
	0,
	_nc_info_table + 217,
	_nc_info_table + 493,
	_nc_info_table + 171,
	_nc_info_table + 172,
	_nc_info_table + 399,
	_nc_info_table + 346,
	0,
	0,
	0,
	0,
	_nc_info_table + 195,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 496,
	0,
	0,
	0,
	0,
	_nc_info_table + 241,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 151,
	0,
	_nc_info_table + 118,
	0,
	_nc_info_table +  62,
	_nc_info_table + 187,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 234,
	0,
	_nc_info_table + 443,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 357,
	0,
	0,
	0,
	_nc_info_table + 246,
	0,
	0,
	0,
	_nc_info_table + 448,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table +  39,
	0,
	_nc_info_table +  10,
	_nc_info_table + 397,
	_nc_info_table + 389,
	0,
	0,
	_nc_info_table + 154,
	0,
	0,
	0,
	_nc_info_table + 130,
	0,
	_nc_info_table +  22,
	_nc_info_table + 222,
	_nc_info_table + 373,
	_nc_info_table + 162,
	0,
	_nc_info_table + 361,
	_nc_info_table + 203,
	0,
	0,
	_nc_info_table + 242,
	0,
	0,
	0,
	0,
	_nc_info_table + 459,
	0,
	0,
	_nc_info_table + 271,
	0,
	_nc_info_table +  97,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 427,
	0,
	_nc_info_table + 175,
	_nc_info_table + 107,
	0,
	0,
	0,
	_nc_info_table + 178,
	_nc_info_table + 423,
	_nc_info_table + 372,
	_nc_info_table +  69,
	0,
	_nc_info_table + 365,
	0,
	_nc_info_table +   4,
	_nc_info_table + 486,
	_nc_info_table + 184,
	0,
	0,
	0,
	0,
	_nc_info_table + 461,
	0,
	0,
	_nc_info_table + 282,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 475,
	0,
	0,
	0,
	_nc_info_table + 395,
	_nc_info_table + 387,
	0,
	0,
	_nc_info_table +  79,
	_nc_info_table +  63,
	0,
	0,
	_nc_info_table + 452,
	_nc_info_table + 451,
	0,
	_nc_info_table +  50,
	0,
	_nc_info_table + 436,
	0,
	0,
	_nc_info_table + 285,
	0,
	0,
	_nc_info_table +  83,
	_nc_info_table + 455,
	0,
	0,
	0,
	_nc_info_table + 279,
	_nc_info_table + 370,
	0,
	0,
	0,
	_nc_info_table +  18,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 421,
	0,
	_nc_info_table + 495,
	0,
	0,
	0,
	0,
	_nc_info_table + 227,
	_nc_info_table + 333,
	0,
	0,
	_nc_info_table +  25,
	_nc_info_table + 139,
	_nc_info_table + 164,
	0,
	0,
	_nc_info_table + 371,
	0,
	0,
	_nc_info_table + 429,
	0,
	0,
	0,
	_nc_info_table + 273,
	0,
	_nc_info_table + 466,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 181,
	0,
	0,
	_nc_info_table +  75,
	0,
	_nc_info_table +  92,
	_nc_info_table + 339,
	0,
	_nc_info_table + 384,
	0,
	_nc_info_table + 123,
	0,
	_nc_info_table + 143,
	_nc_info_table + 168,
	0,
	_nc_info_table + 183,
	_nc_info_table + 186,
	0,
	_nc_info_table + 108,
	_nc_info_table +  95,
	_nc_info_table + 368,
	0,
	0,
	_nc_info_table + 277,
	_nc_info_table + 198,
	0,
	_nc_info_table + 206,
	_nc_info_table + 432,
	0,
	_nc_info_table + 476,
	0,
	_nc_info_table + 458,
	0,
	0,
	_nc_info_table + 182,
	0,
	_nc_info_table + 441,
	0,
	0,
	0,
	_nc_info_table + 115,
	_nc_info_table + 113,
	_nc_info_table + 404,
	0,
	_nc_info_table + 473,
	0,
	0,
	0,
	_nc_info_table + 490,
	_nc_info_table + 104,
	0,
	0,
	_nc_info_table + 450,
	_nc_info_table + 449,
	0,
	0,
	0,
	_nc_info_table + 274,
	0,
	_nc_info_table + 481,
	_nc_info_table + 111,
	_nc_info_table +  99,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 263,
	_nc_info_table +  93,
	0,
	_nc_info_table + 117,
	0,
	_nc_info_table +  29,
	0,
	0,
	0,
	0,
	_nc_info_table + 119,
	0,
	0,
	_nc_info_table + 426,
	_nc_info_table + 491,
	0,
	0,
	_nc_info_table + 205,
	0,
	_nc_info_table + 237,
	_nc_info_table +  44,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 418,
	_nc_info_table + 416,
	0,
	0,
	_nc_info_table + 358,
	0,
	0,
	0,
	_nc_info_table +  65,
	0,
	_nc_info_table + 440,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table +   5,
	0,
	0,
	0,
	_nc_info_table + 488,
	0,
	0,
	0,
	_nc_info_table +  28,
	_nc_info_table + 412,
	0,
	_nc_info_table + 405,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 295,
	0,
	_nc_info_table + 471,
	_nc_info_table + 362,
	0,
	0,
	_nc_info_table + 485,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 202,
	0,
	0,
	_nc_info_table + 284,
	0,
	_nc_info_table + 469,
	0,
	0,
	_nc_info_table +   9,
	_nc_info_table +  24,
	0,
	0,
	_nc_info_table + 179,
	0,
	0,
	_nc_info_table +  15,
	0,
	0,
	_nc_info_table + 148,
	0,
	0,
	0,
	_nc_info_table + 341,
	0,
	0,
	_nc_info_table + 366,
	_nc_info_table + 209,
	_nc_info_table + 223,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table +   0,
	0,
	_nc_info_table + 208,
	_nc_info_table + 467,
	0,
	_nc_info_table + 422,
	0,
	_nc_info_table + 464,
	_nc_info_table + 157,
	0,
	_nc_info_table + 403,
	0,
	_nc_info_table + 415,
	0,
	0,
	0,
	0,
	_nc_info_table + 445,
	0,
	0,
	_nc_info_table + 330,
	0,
	0,
	0,
	_nc_info_table + 462,
	_nc_info_table + 160,
	0,
	0,
	0,
	0,
	_nc_info_table +  86,
	0,
	0,
	_nc_info_table +  41,
	0,
	_nc_info_table + 280,
	0,
	_nc_info_table + 478,
	0,
	0,
	_nc_info_table +  57,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 394,
	_nc_info_table + 414,
	0,
	0,
	0,
	_nc_info_table + 140,
	_nc_info_table + 165,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 275,
	_nc_info_table + 102,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 232,
	0,
	_nc_info_table +  14,
	0,
	0,
	_nc_info_table + 225,
	0,
	0,
	_nc_info_table + 267,
	0,
	_nc_info_table +  77,
	0,
	_nc_info_table + 144,
	_nc_info_table + 169,
	0,
	_nc_info_table + 149,
	0,
	_nc_info_table + 400,
	0,
	0,
	0,
	_nc_info_table +   3,
	0,
	0,
	0,
	_nc_info_table + 468,
	_nc_info_table + 425,
	0,
	0,
	_nc_info_table + 470,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_info_table + 456,
	0,
	_nc_info_table + 158,
	_nc_info_table + 159,
	0,
	0,
	_nc_info_table + 146,
	_nc_info_table +  49,
	0,
	0,
	_nc_info_table + 153,
	0,
	_nc_info_table + 401,
	_nc_info_table +  90,
	_nc_info_table	/* base-of-table */
};

#if (BOOLCOUNT!=44)||(NUMCOUNT!=39)||(STRCOUNT!=414)
#error	--> term.h and comp_captab.c disagree about the <--
#error	--> numbers of booleans, numbers and/or strings <--
#endif

static struct name_table_entry const _nc_cap_table[] =
{
	{            "bw",	   BOOLEAN,	  0,  -1 },
	{            "am",	   BOOLEAN,	  1,  -1 },
	{            "xb",	   BOOLEAN,	  2,  -1 },
	{            "xs",	   BOOLEAN,	  3,  -1 },
	{            "xn",	   BOOLEAN,	  4,  -1 },
	{            "eo",	   BOOLEAN,	  5,  -1 },
	{            "gn",	   BOOLEAN,	  6,  -1 },
	{            "hc",	   BOOLEAN,	  7,  -1 },
	{            "km",	   BOOLEAN,	  8,  -1 },
	{            "hs",	   BOOLEAN,	  9,  -1 },
	{            "in",	   BOOLEAN,	 10,  -1 },
	{            "da",	   BOOLEAN,	 11,  -1 },
	{            "db",	   BOOLEAN,	 12,  -1 },
	{            "mi",	   BOOLEAN,	 13,  -1 },
	{            "ms",	   BOOLEAN,	 14,  -1 },
	{            "os",	   BOOLEAN,	 15,  -1 },
	{            "es",	   BOOLEAN,	 16,  -1 },
	{            "xt",	   BOOLEAN,	 17,  -1 },
	{            "hz",	   BOOLEAN,	 18,  -1 },
	{            "ul",	   BOOLEAN,	 19,  -1 },
	{            "xo",	   BOOLEAN,	 20,  -1 },
	{            "nx",	   BOOLEAN,	 21,  -1 },
	{            "5i",	   BOOLEAN,	 22,  -1 },
	{            "HC",	   BOOLEAN,	 23,  -1 },
	{            "NR",	   BOOLEAN,	 24,   1 },
	{            "NP",	   BOOLEAN,	 25,  -1 },
	{            "ND",	   BOOLEAN,	 26,  -1 },
	{            "cc",	   BOOLEAN,	 27,  -1 },
	{            "ut",	   BOOLEAN,	 28,  -1 },
	{            "hl",	   BOOLEAN,	 29,  -1 },
	{            "YA",	   BOOLEAN,	 30,  -1 },
	{            "YB",	   BOOLEAN,	 31,  -1 },
	{            "YC",	   BOOLEAN,	 32,  -1 },
	{            "YD",	   BOOLEAN,	 33,  -1 },
	{            "YE",	   BOOLEAN,	 34,  -1 },
	{            "YF",	   BOOLEAN,	 35,  -1 },
	{            "YG",	   BOOLEAN,	 36,  -1 },
	{            "co",	    NUMBER,	  0,  -1 },
	{            "it",	    NUMBER,	  1,  -1 },
	{            "li",	    NUMBER,	  2,  -1 },
	{            "lm",	    NUMBER,	  3,  -1 },
	{            "sg",	    NUMBER,	  4,  -1 },
	{            "pb",	    NUMBER,	  5,  -1 },
	{            "vt",	    NUMBER,	  6,  -1 },
	{            "ws",	    NUMBER,	  7,  -1 },
	{            "Nl",	    NUMBER,	  8,  -1 },
	{            "lh",	    NUMBER,	  9,  -1 },
	{            "lw",	    NUMBER,	 10,  -1 },
	{            "ma",	    NUMBER,	 11,  -1 },
	{            "MW",	    NUMBER,	 12,  -1 },
	{            "Co",	    NUMBER,	 13,  -1 },
	{            "pa",	    NUMBER,	 14,  -1 },
	{            "NC",	    NUMBER,	 15,  -1 },
	{            "Ya",	    NUMBER,	 16,  -1 },
	{            "Yb",	    NUMBER,	 17,  -1 },
	{            "Yc",	    NUMBER,	 18,  -1 },
	{            "Yd",	    NUMBER,	 19,  -1 },
	{            "Ye",	    NUMBER,	 20,  -1 },
	{            "Yf",	    NUMBER,	 21,  -1 },
	{            "Yg",	    NUMBER,	 22,  -1 },
	{            "Yh",	    NUMBER,	 23,  -1 },
	{            "Yi",	    NUMBER,	 24,  -1 },
	{            "Yj",	    NUMBER,	 25,  -1 },
	{            "Yk",	    NUMBER,	 26,  -1 },
	{            "Yl",	    NUMBER,	 27,  -1 },
	{            "Ym",	    NUMBER,	 28,  -1 },
	{            "Yn",	    NUMBER,	 29,  -1 },
	{            "BT",	    NUMBER,	 30,  -1 },
	{            "Yo",	    NUMBER,	 31,  -1 },
	{            "Yp",	    NUMBER,	 32,  -1 },
	{            "bt",	    STRING,	  0,  -1 },
	{            "bl",	    STRING,	  1,  -1 },
	{            "cr",	    STRING,	  2,  -1 },
	{            "cs",	    STRING,	  3,  -1 },
	{            "ct",	    STRING,	  4,  -1 },
	{            "cl",	    STRING,	  5,  -1 },
	{            "ce",	    STRING,	  6,  -1 },
	{            "cd",	    STRING,	  7,  -1 },
	{            "ch",	    STRING,	  8,  -1 },
	{            "CC",	    STRING,	  9,  -1 },
	{            "cm",	    STRING,	 10,  -1 },
	{            "do",	    STRING,	 11,  -1 },
	{            "ho",	    STRING,	 12,  -1 },
	{            "vi",	    STRING,	 13,  -1 },
	{            "le",	    STRING,	 14,  -1 },
	{            "CM",	    STRING,	 15,  -1 },
	{            "ve",	    STRING,	 16,  -1 },
	{            "nd",	    STRING,	 17,  -1 },
	{            "ll",	    STRING,	 18,  -1 },
	{            "up",	    STRING,	 19,  -1 },
	{            "vs",	    STRING,	 20,  -1 },
	{            "dc",	    STRING,	 21,  -1 },
	{            "dl",	    STRING,	 22,  -1 },
	{            "ds",	    STRING,	 23,  -1 },
	{            "hd",	    STRING,	 24,  -1 },
	{            "as",	    STRING,	 25,  -1 },
	{            "mb",	    STRING,	 26,  -1 },
	{            "md",	    STRING,	 27,  -1 },
	{            "ti",	    STRING,	 28,  -1 },
	{            "dm",	    STRING,	 29,  -1 },
	{            "mh",	    STRING,	 30,  -1 },
	{            "im",	    STRING,	 31,  -1 },
	{            "mk",	    STRING,	 32,  -1 },
	{            "mp",	    STRING,	 33,  -1 },
	{            "mr",	    STRING,	 34,  -1 },
	{            "so",	    STRING,	 35,  -1 },
	{            "us",	    STRING,	 36,  -1 },
	{            "ec",	    STRING,	 37,  -1 },
	{            "ae",	    STRING,	 38,  -1 },
	{            "me",	    STRING,	 39,  -1 },
	{            "te",	    STRING,	 40,  -1 },
	{            "ed",	    STRING,	 41,  -1 },
	{            "ei",	    STRING,	 42,  -1 },
	{            "se",	    STRING,	 43,  -1 },
	{            "ue",	    STRING,	 44,  -1 },
	{            "vb",	    STRING,	 45,  -1 },
	{            "ff",	    STRING,	 46,  -1 },
	{            "fs",	    STRING,	 47,  -1 },
	{            "i1",	    STRING,	 48, 102 },
	{            "is",	    STRING,	 49,  -1 },
	{            "i3",	    STRING,	 50,  -1 },
	{            "if",	    STRING,	 51,  -1 },
	{            "ic",	    STRING,	 52,  -1 },
	{            "al",	    STRING,	 53,  -1 },
	{            "ip",	    STRING,	 54,  -1 },
	{            "kb",	    STRING,	 55,  -1 },
	{            "ka",	    STRING,	 56,  -1 },
	{            "kC",	    STRING,	 57,  -1 },
	{            "kt",	    STRING,	 58,  -1 },
	{            "kD",	    STRING,	 59,  -1 },
	{            "kL",	    STRING,	 60,  -1 },
	{            "kd",	    STRING,	 61,  -1 },
	{            "kM",	    STRING,	 62,  -1 },
	{            "kE",	    STRING,	 63,  -1 },
	{            "kS",	    STRING,	 64,  -1 },
	{            "k0",	    STRING,	 65,  -1 },
	{            "k1",	    STRING,	 66,  -1 },
	{            "k;",	    STRING,	 67,  -1 },
	{            "k2",	    STRING,	 68,  -1 },
	{            "k3",	    STRING,	 69,  -1 },
	{            "k4",	    STRING,	 70,  -1 },
	{            "k5",	    STRING,	 71,  -1 },
	{            "k6",	    STRING,	 72,  -1 },
	{            "k7",	    STRING,	 73,  -1 },
	{            "k8",	    STRING,	 74,  -1 },
	{            "k9",	    STRING,	 75,  15 },
	{            "kh",	    STRING,	 76,  -1 },
	{            "kI",	    STRING,	 77,  -1 },
	{            "kA",	    STRING,	 78,  -1 },
	{            "kl",	    STRING,	 79,  -1 },
	{            "kH",	    STRING,	 80,  -1 },
	{            "kN",	    STRING,	 81,  -1 },
	{            "kP",	    STRING,	 82,  -1 },
	{            "kr",	    STRING,	 83,  -1 },
	{            "kF",	    STRING,	 84,  -1 },
	{            "kR",	    STRING,	 85,  -1 },
	{            "kT",	    STRING,	 86,  -1 },
	{            "ku",	    STRING,	 87,  -1 },
	{            "ke",	    STRING,	 88,  -1 },
	{            "ks",	    STRING,	 89,  -1 },
	{            "l0",	    STRING,	 90,  -1 },
	{            "l1",	    STRING,	 91,  -1 },
	{            "la",	    STRING,	 92,  35 },
	{            "l2",	    STRING,	 93,  -1 },
	{            "l3",	    STRING,	 94,  -1 },
	{            "l4",	    STRING,	 95,  -1 },
	{            "l5",	    STRING,	 96,  -1 },
	{            "l6",	    STRING,	 97,  -1 },
	{            "l7",	    STRING,	 98,  -1 },
	{            "l8",	    STRING,	 99,  -1 },
	{            "l9",	    STRING,	100,  -1 },
	{            "mo",	    STRING,	101,  -1 },
	{            "mm",	    STRING,	102, 120 },
	{            "nw",	    STRING,	103,  -1 },
	{            "pc",	    STRING,	104,  -1 },
	{            "DC",	    STRING,	105,  -1 },
	{            "DL",	    STRING,	106,  -1 },
	{            "DO",	    STRING,	107,  -1 },
	{            "IC",	    STRING,	108,  -1 },
	{            "SF",	    STRING,	109,  -1 },
	{            "AL",	    STRING,	110,  -1 },
	{            "LE",	    STRING,	111,  -1 },
	{            "RI",	    STRING,	112, 111 },
	{            "SR",	    STRING,	113,  -1 },
	{            "UP",	    STRING,	114,  -1 },
	{            "pk",	    STRING,	115, 161 },
	{            "pl",	    STRING,	116, 163 },
	{            "px",	    STRING,	117,  -1 },
	{            "ps",	    STRING,	118, 170 },
	{            "pf",	    STRING,	119,  -1 },
	{            "po",	    STRING,	120, 166 },
	{            "rp",	    STRING,	121,  -1 },
	{            "r1",	    STRING,	122,  -1 },
	{            "r2",	    STRING,	123,  -1 },
	{            "r3",	    STRING,	124,  -1 },
	{            "rf",	    STRING,	125,  -1 },
	{            "rc",	    STRING,	126,  -1 },
	{            "cv",	    STRING,	127,  -1 },
	{            "sc",	    STRING,	128,  -1 },
	{            "sf",	    STRING,	129,  -1 },
	{            "sr",	    STRING,	130,  -1 },
	{            "sa",	    STRING,	131,  -1 },
	{            "st",	    STRING,	132,  -1 },
	{            "wi",	    STRING,	133,  -1 },
	{            "ta",	    STRING,	134,  -1 },
	{            "ts",	    STRING,	135,  -1 },
	{            "uc",	    STRING,	136,  -1 },
	{            "hu",	    STRING,	137,  -1 },
	{            "iP",	    STRING,	138,  -1 },
	{            "K1",	    STRING,	139,  -1 },
	{            "K3",	    STRING,	140,  -1 },
	{            "K2",	    STRING,	141,  -1 },
	{            "K4",	    STRING,	142,  -1 },
	{            "K5",	    STRING,	143,  -1 },
	{            "pO",	    STRING,	144,  -1 },
	{            "rP",	    STRING,	145,  37 },
	{            "ac",	    STRING,	146,  -1 },
	{            "pn",	    STRING,	147, 165 },
	{            "kB",	    STRING,	148,  -1 },
	{            "SX",	    STRING,	149, 117 },
	{            "RX",	    STRING,	150,  16 },
	{            "SA",	    STRING,	151,  -1 },
	{            "RA",	    STRING,	152,  -1 },
	{            "XN",	    STRING,	153,  -1 },
	{            "XF",	    STRING,	154, 126 },
	{            "eA",	    STRING,	155,  -1 },
	{            "LO",	    STRING,	156,  -1 },
	{            "LF",	    STRING,	157,  -1 },
	{            "@1",	    STRING,	158,  -1 },
	{            "@2",	    STRING,	159,  -1 },
	{            "@3",	    STRING,	160,  -1 },
	{            "@4",	    STRING,	161,  -1 },
	{            "@5",	    STRING,	162,  -1 },
	{            "@6",	    STRING,	163,  -1 },
	{            "@7",	    STRING,	164, 183 },
	{            "@8",	    STRING,	165,  -1 },
	{            "@9",	    STRING,	166,  -1 },
	{            "@0",	    STRING,	167, 116 },
	{            "%1",	    STRING,	168,  -1 },
	{            "%2",	    STRING,	169,  97 },
	{            "%3",	    STRING,	170, 109 },
	{            "%4",	    STRING,	171,  -1 },
	{            "%5",	    STRING,	172,  -1 },
	{            "%6",	    STRING,	173, 100 },
	{            "%7",	    STRING,	174,  13 },
	{            "%8",	    STRING,	175,  -1 },
	{            "%9",	    STRING,	176, 118 },
	{            "%0",	    STRING,	177,  96 },
	{            "&1",	    STRING,	178,  -1 },
	{            "&2",	    STRING,	179,  87 },
	{            "&3",	    STRING,	180,  -1 },
	{            "&4",	    STRING,	181,  -1 },
	{            "&5",	    STRING,	182,  -1 },
	{            "&6",	    STRING,	183,  -1 },
	{            "&7",	    STRING,	184,  -1 },
	{            "&8",	    STRING,	185,  -1 },
	{            "&9",	    STRING,	186,  -1 },
	{            "&0",	    STRING,	187,  -1 },
	{            "*1",	    STRING,	188, 196 },
	{            "*2",	    STRING,	189,  -1 },
	{            "*3",	    STRING,	190,  -1 },
	{            "*4",	    STRING,	191, 195 },
	{            "*5",	    STRING,	192,  -1 },
	{            "*6",	    STRING,	193,  -1 },
	{            "*7",	    STRING,	194,  -1 },
	{            "*8",	    STRING,	195,  -1 },
	{            "*9",	    STRING,	196,  -1 },
	{            "*0",	    STRING,	197,  -1 },
	{            "#1",	    STRING,	198,  -1 },
	{            "#2",	    STRING,	199, 131 },
	{            "#3",	    STRING,	200, 158 },
	{            "#4",	    STRING,	201,  -1 },
	{            "%a",	    STRING,	202,  -1 },
	{            "%b",	    STRING,	203,  -1 },
	{            "%c",	    STRING,	204,  -1 },
	{            "%d",	    STRING,	205,  -1 },
	{            "%e",	    STRING,	206,  -1 },
	{            "%f",	    STRING,	207,  -1 },
	{            "%g",	    STRING,	208,  -1 },
	{            "%h",	    STRING,	209,  -1 },
	{            "%i",	    STRING,	210,  -1 },
	{            "%j",	    STRING,	211,  -1 },
	{            "!1",	    STRING,	212, 122 },
	{            "!2",	    STRING,	213,  -1 },
	{            "!3",	    STRING,	214,  -1 },
	{            "RF",	    STRING,	215,  -1 },
	{            "F1",	    STRING,	216,  -1 },
	{            "F2",	    STRING,	217,  46 },
	{            "F3",	    STRING,	218,  39 },
	{            "F4",	    STRING,	219,  -1 },
	{            "F5",	    STRING,	220,  -1 },
	{            "F6",	    STRING,	221,  88 },
	{            "F7",	    STRING,	222,  40 },
	{            "F8",	    STRING,	223,  -1 },
	{            "F9",	    STRING,	224,  -1 },
	{            "FA",	    STRING,	225,  47 },
	{            "FB",	    STRING,	226,  -1 },
	{            "FC",	    STRING,	227,  -1 },
	{            "FD",	    STRING,	228,  -1 },
	{            "FE",	    STRING,	229,  -1 },
	{            "FF",	    STRING,	230,  53 },
	{            "FG",	    STRING,	231,  54 },
	{            "FH",	    STRING,	232,  55 },
	{            "FI",	    STRING,	233,  56 },
	{            "FJ",	    STRING,	234,  57 },
	{            "FK",	    STRING,	235,  58 },
	{            "FL",	    STRING,	236,  59 },
	{            "FM",	    STRING,	237,  60 },
	{            "FN",	    STRING,	238,  61 },
	{            "FO",	    STRING,	239,  62 },
	{            "FP",	    STRING,	240,  63 },
	{            "FQ",	    STRING,	241,  64 },
	{            "FR",	    STRING,	242,  65 },
	{            "FS",	    STRING,	243,  66 },
	{            "FT",	    STRING,	244,  68 },
	{            "FU",	    STRING,	245,  69 },
	{            "FV",	    STRING,	246,  -1 },
	{            "FW",	    STRING,	247,  -1 },
	{            "FX",	    STRING,	248,  -1 },
	{            "FY",	    STRING,	249,  -1 },
	{            "FZ",	    STRING,	250,  -1 },
	{            "Fa",	    STRING,	251,  -1 },
	{            "Fb",	    STRING,	252,  -1 },
	{            "Fc",	    STRING,	253,  -1 },
	{            "Fd",	    STRING,	254,  -1 },
	{            "Fe",	    STRING,	255,  -1 },
	{            "Ff",	    STRING,	256,  -1 },
	{            "Fg",	    STRING,	257,   7 },
	{            "Fh",	    STRING,	258,  94 },
	{            "Fi",	    STRING,	259,  -1 },
	{            "Fj",	    STRING,	260,  -1 },
	{            "Fk",	    STRING,	261,  -1 },
	{            "Fl",	    STRING,	262,  -1 },
	{            "Fm",	    STRING,	263,  -1 },
	{            "Fn",	    STRING,	264,  -1 },
	{            "Fo",	    STRING,	265, 184 },
	{            "Fp",	    STRING,	266,  29 },
	{            "Fq",	    STRING,	267,  -1 },
	{            "Fr",	    STRING,	268,  -1 },
	{            "cb",	    STRING,	269,  -1 },
	{            "MC",	    STRING,	270,  -1 },
	{            "ML",	    STRING,	271,  -1 },
	{            "MR",	    STRING,	272,  -1 },
	{            "Lf",	    STRING,	273, 257 },
	{            "SC",	    STRING,	274,  -1 },
	{            "DK",	    STRING,	275,  -1 },
	{            "RC",	    STRING,	276,  -1 },
	{            "CW",	    STRING,	277,   4 },
	{            "WG",	    STRING,	278,  -1 },
	{            "HU",	    STRING,	279,  -1 },
	{            "DI",	    STRING,	280,  -1 },
	{            "QD",	    STRING,	281,  -1 },
	{            "TO",	    STRING,	282,  -1 },
	{            "PU",	    STRING,	283,  -1 },
	{            "fh",	    STRING,	284, 229 },
	{            "PA",	    STRING,	285,  -1 },
	{            "WA",	    STRING,	286,  -1 },
	{            "u0",	    STRING,	287,  -1 },
	{            "u1",	    STRING,	288,  -1 },
	{            "u2",	    STRING,	289,  -1 },
	{            "u3",	    STRING,	290,  -1 },
	{            "u4",	    STRING,	291,  -1 },
	{            "u5",	    STRING,	292,  -1 },
	{            "u6",	    STRING,	293,  -1 },
	{            "u7",	    STRING,	294,  -1 },
	{            "u8",	    STRING,	295,  -1 },
	{            "u9",	    STRING,	296,  -1 },
	{            "op",	    STRING,	297, 142 },
	{            "oc",	    STRING,	298,  -1 },
	{            "Ic",	    STRING,	299,  -1 },
	{            "Ip",	    STRING,	300, 149 },
	{            "sp",	    STRING,	301,  -1 },
	{            "Sf",	    STRING,	302,  -1 },
	{            "Sb",	    STRING,	303,  -1 },
	{            "ZA",	    STRING,	304,  -1 },
	{            "ZB",	    STRING,	305,  -1 },
	{            "ZC",	    STRING,	306,  -1 },
	{            "ZD",	    STRING,	307,  -1 },
	{            "ZE",	    STRING,	308,  -1 },
	{            "ZF",	    STRING,	309,  48 },
	{            "ZG",	    STRING,	310, 247 },
	{            "ZH",	    STRING,	311, 238 },
	{            "ZI",	    STRING,	312, 239 },
	{            "ZJ",	    STRING,	313, 240 },
	{            "ZK",	    STRING,	314, 241 },
	{            "ZL",	    STRING,	315, 242 },
	{            "ZM",	    STRING,	316, 243 },
	{            "ZN",	    STRING,	317, 244 },
	{            "ZO",	    STRING,	318, 245 },
	{            "ZP",	    STRING,	319, 246 },
	{            "ZQ",	    STRING,	320,  -1 },
	{            "ZR",	    STRING,	321, 172 },
	{            "ZS",	    STRING,	322,  -1 },
	{            "ZT",	    STRING,	323, 171 },
	{            "ZU",	    STRING,	324, 103 },
	{            "ZV",	    STRING,	325,  -1 },
	{            "ZW",	    STRING,	326, 104 },
	{            "ZX",	    STRING,	327,  14 },
	{            "ZY",	    STRING,	328,  -1 },
	{            "ZZ",	    STRING,	329,  -1 },
	{            "Za",	    STRING,	330,  -1 },
	{            "Zb",	    STRING,	331,  -1 },
	{            "Zc",	    STRING,	332,  -1 },
	{            "Zd",	    STRING,	333,  -1 },
	{            "Ze",	    STRING,	334,  -1 },
	{            "Zf",	    STRING,	335,  -1 },
	{            "Zg",	    STRING,	336,  -1 },
	{            "Zh",	    STRING,	337,  -1 },
	{            "Zi",	    STRING,	338,  -1 },
	{            "Zj",	    STRING,	339,  -1 },
	{            "Zk",	    STRING,	340,  -1 },
	{            "Zl",	    STRING,	341,  -1 },
	{            "Zm",	    STRING,	342,  -1 },
	{            "Zn",	    STRING,	343,  -1 },
	{            "Zo",	    STRING,	344, 208 },
	{            "Zp",	    STRING,	345,  -1 },
	{            "Zq",	    STRING,	346,  -1 },
	{            "Zr",	    STRING,	347,  -1 },
	{            "Zs",	    STRING,	348,  -1 },
	{            "Zt",	    STRING,	349,  -1 },
	{            "Zu",	    STRING,	350,  -1 },
	{            "Zv",	    STRING,	351,  -1 },
	{            "Zw",	    STRING,	352,  -1 },
	{            "Zx",	    STRING,	353, 272 },
	{            "Zy",	    STRING,	354, 273 },
	{            "Km",	    STRING,	355, 387 },
	{            "Mi",	    STRING,	356,  -1 },
	{            "RQ",	    STRING,	357,  -1 },
	{            "Gm",	    STRING,	358,  -1 },
	{            "AF",	    STRING,	359,  -1 },
	{            "AB",	    STRING,	360,  -1 },
	{            "xl",	    STRING,	361,  -1 },
	{            "dv",	    STRING,	362,  -1 },
	{            "ci",	    STRING,	363,  -1 },
	{            "s0",	    STRING,	364,  -1 },
	{            "s1",	    STRING,	365,  67 },
	{            "s2",	    STRING,	366,  -1 },
	{            "s3",	    STRING,	367,  -1 },
	{            "ML",	    STRING,	368, 341 },
	{            "MT",	    STRING,	369,  -1 },
	{            "Xy",	    STRING,	370,  -1 },
	{            "Zz",	    STRING,	371, 274 },
	{            "Yv",	    STRING,	372,  -1 },
	{            "Yw",	    STRING,	373,  -1 },
	{            "Yx",	    STRING,	374,  -1 },
	{            "Yy",	    STRING,	375,  -1 },
	{            "Yz",	    STRING,	376,  -1 },
	{            "YZ",	    STRING,	377,  -1 },
	{            "S1",	    STRING,	378,  -1 },
	{            "S2",	    STRING,	379,  -1 },
	{            "S3",	    STRING,	380,  -1 },
	{            "S4",	    STRING,	381, 357 },
	{            "S5",	    STRING,	382, 358 },
	{            "S6",	    STRING,	383, 359 },
	{            "S7",	    STRING,	384, 360 },
	{            "S8",	    STRING,	385, 361 },
	{            "Xh",	    STRING,	386,  -1 },
	{            "Xl",	    STRING,	387,  -1 },
	{            "Xo",	    STRING,	388,  -1 },
	{            "Xr",	    STRING,	389,  -1 },
	{            "Xt",	    STRING,	390,  -1 },
	{            "Xv",	    STRING,	391,  -1 },
	{            "sA",	    STRING,	392,  -1 },
	{            "sL",	    STRING,	393,  -1 },
	{            "i2",	    STRING,	394, 390 },
	{            "rs",	    STRING,	395,  -1 },
	{            "ug",	    NUMBER,	 33,  -1 },
	{            "bs",	   BOOLEAN,	 37,  -1 },
	{            "ns",	   BOOLEAN,	 38,  -1 },
	{            "nc",	   BOOLEAN,	 39, 248 },
	{            "dC",	    NUMBER,	 34,  -1 },
	{            "dN",	    NUMBER,	 35, 203 },
	{            "nl",	    STRING,	396,  -1 },
	{            "bc",	    STRING,	397,  -1 },
	{            "MT",	   BOOLEAN,	 40, 439 },
	{            "NL",	   BOOLEAN,	 41,  -1 },
	{            "dB",	    NUMBER,	 36,  -1 },
	{            "dT",	    NUMBER,	 37,  -1 },
	{            "kn",	    NUMBER,	 38,  -1 },
	{            "ko",	    STRING,	398,  -1 },
	{            "ma",	    STRING,	399, 379 },
	{            "pt",	   BOOLEAN,	 42,  -1 },
	{            "xr",	   BOOLEAN,	 43,  -1 },
	{            "G2",	    STRING,	400, 386 },
	{            "G3",	    STRING,	401, 425 },
	{            "G1",	    STRING,	402, 385 },
	{            "G4",	    STRING,	403, 388 },
	{            "GR",	    STRING,	404, 412 },
	{            "GL",	    STRING,	405, 406 },
	{            "GU",	    STRING,	406, 415 },
	{            "GD",	    STRING,	407,  -1 },
	{            "GH",	    STRING,	408, 402 },
	{            "GV",	    STRING,	409, 416 },
	{            "GC",	    STRING,	410,  -1 },
	{            "ml",	    STRING,	411, 464 },
	{            "mu",	    STRING,	412, 399 },
	{            "bx",	    STRING,	413,  -1 } 
};

const struct name_table_entry * const _nc_cap_hash_table[995] =
{
	_nc_cap_table + 253,
	0,
	_nc_cap_table +  45,
	_nc_cap_table + 211,
	_nc_cap_table + 263,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 449,
	_nc_cap_table + 457,
	_nc_cap_table + 311,
	_nc_cap_table + 411,
	0,
	_nc_cap_table + 132,
	0,
	0,
	0,
	0,
	_nc_cap_table + 123,
	_nc_cap_table +  71,
	_nc_cap_table +  75,
	_nc_cap_table +  92,
	_nc_cap_table + 427,
	_nc_cap_table + 233,
	0,
	_nc_cap_table + 336,
	0,
	0,
	_nc_cap_table + 370,
	_nc_cap_table + 291,
	_nc_cap_table + 494,
	_nc_cap_table + 472,
	_nc_cap_table + 138,
	_nc_cap_table + 186,
	0,
	0,
	0,
	0,
	_nc_cap_table +  19,
	_nc_cap_table + 193,
	_nc_cap_table + 436,
	_nc_cap_table + 431,
	_nc_cap_table + 453,
	0,
	_nc_cap_table + 315,
	_nc_cap_table + 489,
	_nc_cap_table + 349,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 353,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 124,
	0,
	0,
	0,
	_nc_cap_table + 394,
	0,
	_nc_cap_table + 367,
	_nc_cap_table + 167,
	0,
	_nc_cap_table + 191,
	_nc_cap_table + 371,
	0,
	_nc_cap_table +  89,
	0,
	0,
	0,
	_nc_cap_table + 363,
	_nc_cap_table + 460,
	_nc_cap_table + 319,
	_nc_cap_table + 419,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  70,
	_nc_cap_table +  74,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  38,
	0,
	_nc_cap_table + 128,
	0,
	_nc_cap_table + 398,
	0,
	0,
	_nc_cap_table + 481,
	0,
	0,
	_nc_cap_table + 202,
	0,
	_nc_cap_table +  28,
	_nc_cap_table +  43,
	0,
	_nc_cap_table +  17,
	0,
	0,
	_nc_cap_table + 444,
	_nc_cap_table + 423,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 496,
	0,
	0,
	0,
	0,
	_nc_cap_table + 430,
	0,
	0,
	0,
	0,
	_nc_cap_table + 296,
	0,
	_nc_cap_table +  21,
	0,
	_nc_cap_table + 187,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 321,
	_nc_cap_table + 276,
	0,
	0,
	_nc_cap_table +  31,
	_nc_cap_table + 375,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 429,
	_nc_cap_table + 476,
	0,
	0,
	0,
	_nc_cap_table + 300,
	_nc_cap_table + 400,
	0,
	_nc_cap_table + 218,
	0,
	0,
	_nc_cap_table + 227,
	0,
	0,
	0,
	0,
	_nc_cap_table +  11,
	_nc_cap_table + 285,
	_nc_cap_table + 179,
	0,
	_nc_cap_table + 325,
	_nc_cap_table + 280,
	0,
	_nc_cap_table + 224,
	_nc_cap_table + 162,
	_nc_cap_table + 480,
	0,
	0,
	_nc_cap_table +  51,
	0,
	0,
	_nc_cap_table + 201,
	_nc_cap_table + 204,
	0,
	0,
	0,
	0,
	_nc_cap_table +  22,
	0,
	_nc_cap_table + 304,
	_nc_cap_table + 404,
	0,
	_nc_cap_table + 154,
	0,
	0,
	0,
	0,
	_nc_cap_table + 108,
	0,
	_nc_cap_table +  76,
	0,
	0,
	0,
	0,
	_nc_cap_table + 329,
	_nc_cap_table + 284,
	0,
	_nc_cap_table + 270,
	_nc_cap_table +  84,
	_nc_cap_table + 383,
	_nc_cap_table + 250,
	_nc_cap_table + 426,
	0,
	0,
	_nc_cap_table + 260,
	_nc_cap_table + 113,
	_nc_cap_table + 110,
	_nc_cap_table + 114,
	_nc_cap_table +  86,
	0,
	0,
	0,
	0,
	_nc_cap_table + 308,
	_nc_cap_table + 408,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 433,
	0,
	_nc_cap_table + 112,
	_nc_cap_table + 230,
	0,
	_nc_cap_table + 333,
	_nc_cap_table + 428,
	0,
	_nc_cap_table + 223,
	_nc_cap_table + 288,
	_nc_cap_table + 484,
	_nc_cap_table + 254,
	0,
	0,
	_nc_cap_table + 210,
	_nc_cap_table + 264,
	0,
	_nc_cap_table +  98,
	0,
	_nc_cap_table +  83,
	_nc_cap_table + 471,
	0,
	_nc_cap_table + 450,
	0,
	_nc_cap_table + 312,
	_nc_cap_table + 487,
	0,
	_nc_cap_table + 151,
	0,
	0,
	0,
	_nc_cap_table + 342,
	_nc_cap_table +  24,
	0,
	_nc_cap_table +  80,
	_nc_cap_table +  99,
	0,
	_nc_cap_table + 234,
	0,
	_nc_cap_table + 337,
	_nc_cap_table + 101,
	0,
	_nc_cap_table +   8,
	_nc_cap_table + 292,
	_nc_cap_table + 391,
	0,
	_nc_cap_table + 139,
	_nc_cap_table + 164,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 194,
	_nc_cap_table + 437,
	0,
	_nc_cap_table + 454,
	0,
	_nc_cap_table + 316,
	_nc_cap_table + 492,
	0,
	_nc_cap_table + 155,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 395,
	0,
	_nc_cap_table + 143,
	_nc_cap_table + 168,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 364,
	0,
	_nc_cap_table + 320,
	_nc_cap_table + 420,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 207,
	0,
	0,
	_nc_cap_table + 157,
	_nc_cap_table + 447,
	_nc_cap_table + 495,
	0,
	_nc_cap_table + 137,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 440,
	_nc_cap_table + 445,
	_nc_cap_table + 424,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  79,
	_nc_cap_table + 175,
	0,
	_nc_cap_table + 297,
	_nc_cap_table + 493,
	_nc_cap_table +  23,
	_nc_cap_table + 178,
	0,
	0,
	0,
	_nc_cap_table + 340,
	_nc_cap_table +  52,
	0,
	0,
	0,
	_nc_cap_table + 346,
	_nc_cap_table + 344,
	0,
	_nc_cap_table + 322,
	_nc_cap_table + 277,
	0,
	0,
	_nc_cap_table +  32,
	_nc_cap_table + 376,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 373,
	0,
	_nc_cap_table + 470,
	0,
	0,
	0,
	_nc_cap_table + 301,
	_nc_cap_table + 401,
	0,
	_nc_cap_table + 127,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 339,
	_nc_cap_table +  12,
	0,
	0,
	0,
	_nc_cap_table + 326,
	_nc_cap_table + 281,
	_nc_cap_table + 348,
	_nc_cap_table + 125,
	_nc_cap_table +  36,
	_nc_cap_table + 380,
	_nc_cap_table + 343,
	0,
	_nc_cap_table +  42,
	0,
	_nc_cap_table + 267,
	0,
	0,
	_nc_cap_table + 372,
	_nc_cap_table + 115,
	0,
	_nc_cap_table +   2,
	_nc_cap_table + 345,
	0,
	_nc_cap_table + 305,
	_nc_cap_table + 405,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 237,
	0,
	_nc_cap_table + 330,
	_nc_cap_table + 121,
	0,
	_nc_cap_table + 271,
	0,
	_nc_cap_table + 384,
	_nc_cap_table + 251,
	0,
	_nc_cap_table + 189,
	0,
	_nc_cap_table + 261,
	_nc_cap_table + 199,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 177,
	0,
	_nc_cap_table + 309,
	_nc_cap_table + 409,
	0,
	0,
	0,
	0,
	_nc_cap_table + 226,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 231,
	_nc_cap_table + 352,
	_nc_cap_table + 334,
	0,
	0,
	0,
	_nc_cap_table + 289,
	_nc_cap_table + 486,
	_nc_cap_table + 255,
	_nc_cap_table + 135,
	_nc_cap_table + 160,
	_nc_cap_table + 212,
	_nc_cap_table + 265,
	0,
	0,
	0,
	0,
	_nc_cap_table + 434,
	0,
	_nc_cap_table + 451,
	0,
	_nc_cap_table + 313,
	_nc_cap_table + 413,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 214,
	0,
	0,
	0,
	0,
	_nc_cap_table + 235,
	_nc_cap_table +   6,
	_nc_cap_table + 338,
	_nc_cap_table +  10,
	0,
	_nc_cap_table + 478,
	_nc_cap_table + 293,
	_nc_cap_table + 392,
	0,
	_nc_cap_table + 140,
	_nc_cap_table + 217,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 347,
	_nc_cap_table + 455,
	_nc_cap_table + 459,
	_nc_cap_table + 317,
	_nc_cap_table + 417,
	0,
	_nc_cap_table + 134,
	0,
	0,
	0,
	_nc_cap_table +  49,
	0,
	0,
	_nc_cap_table +  72,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 153,
	0,
	_nc_cap_table + 396,
	0,
	_nc_cap_table + 144,
	_nc_cap_table + 169,
	0,
	0,
	_nc_cap_table + 200,
	0,
	0,
	0,
	0,
	_nc_cap_table + 482,
	_nc_cap_table + 365,
	_nc_cap_table + 461,
	_nc_cap_table + 442,
	_nc_cap_table + 421,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 197,
	_nc_cap_table + 432,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 446,
	_nc_cap_table + 441,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  18,
	0,
	0,
	0,
	_nc_cap_table + 298,
	_nc_cap_table + 490,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  26,
	0,
	0,
	_nc_cap_table + 351,
	0,
	0,
	0,
	_nc_cap_table + 323,
	_nc_cap_table + 278,
	0,
	_nc_cap_table + 369,
	_nc_cap_table +  33,
	_nc_cap_table + 377,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 302,
	_nc_cap_table + 491,
	0,
	_nc_cap_table + 129,
	0,
	0,
	0,
	0,
	_nc_cap_table + 216,
	_nc_cap_table + 473,
	_nc_cap_table +  27,
	_nc_cap_table +  91,
	_nc_cap_table + 107,
	0,
	0,
	_nc_cap_table + 327,
	_nc_cap_table + 282,
	0,
	_nc_cap_table + 268,
	0,
	_nc_cap_table + 381,
	_nc_cap_table + 469,
	_nc_cap_table + 368,
	_nc_cap_table + 174,
	0,
	_nc_cap_table + 258,
	_nc_cap_table + 198,
	0,
	_nc_cap_table + 206,
	_nc_cap_table + 180,
	0,
	0,
	_nc_cap_table + 176,
	0,
	_nc_cap_table + 306,
	_nc_cap_table + 488,
	0,
	_nc_cap_table + 150,
	0,
	0,
	0,
	_nc_cap_table + 438,
	_nc_cap_table + 475,
	0,
	0,
	0,
	0,
	_nc_cap_table + 228,
	0,
	_nc_cap_table + 331,
	0,
	0,
	0,
	_nc_cap_table + 286,
	_nc_cap_table + 485,
	_nc_cap_table + 252,
	0,
	0,
	_nc_cap_table + 209,
	_nc_cap_table + 262,
	_nc_cap_table +  41,
	0,
	_nc_cap_table + 466,
	0,
	0,
	0,
	_nc_cap_table + 448,
	0,
	_nc_cap_table + 310,
	_nc_cap_table + 410,
	0,
	_nc_cap_table + 130,
	0,
	0,
	0,
	0,
	_nc_cap_table +  25,
	0,
	0,
	_nc_cap_table + 463,
	_nc_cap_table +  50,
	_nc_cap_table + 232,
	0,
	_nc_cap_table + 335,
	0,
	0,
	0,
	_nc_cap_table + 290,
	_nc_cap_table + 389,
	_nc_cap_table + 256,
	_nc_cap_table + 136,
	_nc_cap_table + 185,
	_nc_cap_table + 213,
	_nc_cap_table + 266,
	0,
	0,
	0,
	_nc_cap_table + 192,
	_nc_cap_table + 435,
	0,
	_nc_cap_table + 452,
	_nc_cap_table + 458,
	_nc_cap_table + 314,
	_nc_cap_table + 414,
	0,
	_nc_cap_table + 152,
	0,
	0,
	0,
	_nc_cap_table + 474,
	0,
	0,
	_nc_cap_table + 215,
	_nc_cap_table +  81,
	_nc_cap_table +   5,
	_nc_cap_table + 236,
	0,
	_nc_cap_table +  82,
	0,
	0,
	_nc_cap_table + 479,
	_nc_cap_table + 294,
	_nc_cap_table + 393,
	0,
	_nc_cap_table + 141,
	_nc_cap_table + 190,
	0,
	0,
	_nc_cap_table + 105,
	0,
	0,
	0,
	_nc_cap_table + 477,
	_nc_cap_table +  20,
	_nc_cap_table + 362,
	0,
	_nc_cap_table + 318,
	_nc_cap_table + 418,
	0,
	_nc_cap_table + 156,
	0,
	0,
	0,
	0,
	_nc_cap_table +  95,
	_nc_cap_table + 467,
	_nc_cap_table +  73,
	_nc_cap_table +  93,
	_nc_cap_table + 220,
	_nc_cap_table + 219,
	0,
	_nc_cap_table +   9,
	_nc_cap_table + 119,
	0,
	_nc_cap_table + 159,
	0,
	_nc_cap_table + 397,
	_nc_cap_table + 468,
	_nc_cap_table + 145,
	_nc_cap_table + 188,
	0,
	_nc_cap_table + 465,
	0,
	_nc_cap_table + 205,
	_nc_cap_table + 106,
	_nc_cap_table +  90,
	_nc_cap_table +  44,
	_nc_cap_table +   3,
	_nc_cap_table + 366,
	0,
	_nc_cap_table + 443,
	_nc_cap_table + 422,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +   0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 295,
	0,
	_nc_cap_table + 173,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 355,
	0,
	_nc_cap_table + 222,
	_nc_cap_table + 221,
	0,
	0,
	_nc_cap_table + 275,
	_nc_cap_table + 356,
	0,
	_nc_cap_table +  30,
	_nc_cap_table + 374,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 225,
	0,
	0,
	_nc_cap_table + 299,
	0,
	0,
	_nc_cap_table + 148,
	0,
	0,
	_nc_cap_table + 181,
	0,
	0,
	0,
	0,
	_nc_cap_table + 462,
	0,
	0,
	0,
	_nc_cap_table + 324,
	_nc_cap_table + 279,
	0,
	0,
	_nc_cap_table +  34,
	_nc_cap_table + 378,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table + 350,
	0,
	_nc_cap_table + 303,
	_nc_cap_table + 403,
	0,
	_nc_cap_table + 133,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  77,
	0,
	_nc_cap_table + 182,
	0,
	0,
	_nc_cap_table + 328,
	_nc_cap_table + 283,
	0,
	_nc_cap_table + 269,
	0,
	_nc_cap_table + 382,
	_nc_cap_table + 249,
	0,
	0,
	0,
	_nc_cap_table + 259,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  85,
	0,
	_nc_cap_table + 456,
	_nc_cap_table + 307,
	_nc_cap_table + 407,
	0,
	_nc_cap_table + 147,
	0,
	0,
	0,
	0,
	0,
	0,
	_nc_cap_table +  78,
	0,
	0,
	_nc_cap_table + 354,
	0,
	_nc_cap_table + 332,
	0,
	0,
	_nc_cap_table + 146,
	_nc_cap_table + 287,
	_nc_cap_table + 483,
	_nc_cap_table	/* base-of-table */
};

#if (BOOLCOUNT!=44)||(NUMCOUNT!=39)||(STRCOUNT!=414)
#error	--> term.h and comp_captab.c disagree about the <--
#error	--> numbers of booleans, numbers and/or strings <--
#endif

const struct alias _nc_capalias_table[] =
{
	{"sb", "sr", "BSD"},	 /* scroll */
	{"BO", "mr", "AT&T"},	 /* enter_reverse_mode */
	{"CI", "vi", "AT&T"},	 /* cursor_invisible */
	{"CV", "ve", "AT&T"},	 /* cursor_normal */
	{"DS", "mh", "AT&T"},	 /* enter_dim_mode */
	{"FE", "LF", "AT&T"},	 /* label_on */
	{"FL", "LO", "AT&T"},	 /* label_off */
	{"XS", "mk", "AT&T"},	 /* enter_secure_mode */
	{"EE", "mh", "XENIX"},	 /* exit_attribute_mode */
	{"GE", "ae", "XENIX"},	 /* exit_alt_charset_mode */
	{"GS", "as", "XENIX"},	 /* enter_alt_charset_mode */
	{"CF", "vi", "XENIX"},	 /* cursor_invis */
	{"CO", "ve", "XENIX"},	 /* cursor_normal */
	{"EN", "@7", "XENIX"},	 /* key_end */
	{"HM", "kh", "XENIX"},	 /* key_home */
	{"LD", "kL", "XENIX"},	 /* key_dl */
	{"PD", "kN", "XENIX"},	 /* key_npage */
	{"PN", "po", "XENIX"},	 /* prtr_off */
	{"PS", "pf", "XENIX"},	 /* prtr_on */
	{"PU", "kP", "XENIX"},	 /* key_ppage */
	{"RT", "@8", "XENIX"},	 /* kent */
	{"UP", "ku", "XENIX"},	 /* kcuu1 */
	{"G6", (char *)NULL, "XENIX"},	 /* double-ACS_ULCORNER */
	{"G7", (char *)NULL, "XENIX"},	 /* double-ACS_LLCORNER */
	{"G5", (char *)NULL, "XENIX"},	 /* double-ACS_URCORNER */
	{"G8", (char *)NULL, "XENIX"},	 /* double-ACS_LRCORNER */
	{"Gr", (char *)NULL, "XENIX"},	 /* double-ACS_LTEE */
	{"Gr", (char *)NULL, "XENIX"},	 /* double-ACS_RTEE */
	{"Gu", (char *)NULL, "XENIX"},	 /* double-ACS_BTEE */
	{"Gd", (char *)NULL, "XENIX"},	 /* double */
	{"Gh", (char *)NULL, "XENIX"},	 /* double-ACS_HLINE */
	{"Gv", (char *)NULL, "XENIX"},	 /* double-ACS_VLINE */
	{"Gc", (char *)NULL, "XENIX"},	 /* double-ACS_PLUS */
	{"GG", (char *)NULL, "XENIX"},	 /* acs-glitch */
	{"kq", "%1", "IBM"},	 /* key_help */
	{"HS", "mh", "IRIS"},	 /* enter_dim_mode */
	{"KA", "k;", "Tek"},	 /* key_f10 */
	{"KB", "F1", "Tek"},	 /* key_f11 */
	{"KC", "F2", "Tek"},	 /* key_f12 */
	{"KD", "F3", "Tek"},	 /* key_f13 */
	{"KE", "F4", "Tek"},	 /* key_f14 */
	{"KF", "F5", "Tek"},	 /* key_f15 */
	{"BC", "Sb", "Tek"},	 /* set_background */
	{"FC", "Sf", "Tek"},	 /* set_foreground */
	{(char *)NULL, (char *)NULL, (char *)NULL}
};

const struct alias _nc_infoalias_table[] =
{
	{"font0", "s0ds", "IBM"},	 /* set0_des_seq */
	{"font1", "s1ds", "IBM"},	 /* set1_des_seq */
	{"font2", "s2ds", "IBM"},	 /* set2_des_seq */
	{"font3", "s3ds", "IBM"},	 /* set3_des_seq */
	{"kbtab", "kcbt", "IBM"},	 /* key_backtab */
	{"ksel", "kslt", "IBM"},	 /* key_select */
	{(char *)NULL, (char *)NULL, (char *)NULL}
};

NCURSES_EXPORT(const struct name_table_entry *) _nc_get_table (bool termcap)
{
	return termcap ? _nc_cap_table: _nc_info_table ;
}

NCURSES_EXPORT(const struct name_table_entry * const *) _nc_get_hash_table (bool termcap)
{
	return termcap ? _nc_cap_hash_table: _nc_info_hash_table ;
}
