//----------------------------------------------------------------------
//  This software is part of the OpenBeOS distribution and is covered 
//  by the OpenBeOS license.
//
//  Copyright (c) 2003 Tyler Dauwalder, tyler@dauwalder.net
//---------------------------------------------------------------------

/*! \file crc_table.cpp

	Standalone program to generate the CRC table used for calculating
	UDF tag id CRC values.
	
	This code based off of crc code in UDF-2.50 specs, as permitted.
	See UDF-2.50 6.5 for more information.	
*/

#include <stdio.h>

int
main(int argc, char *argv[]) {
	ulong crc, poly;

	if (argc != 2) {
		fprintf(stderr, "USAGE: crc_table <octal polynomial=010041 for UDF>\n");
		return 0;
	}

	sscanf(argv[1], "%lo", &poly);
	if (poly & 0xffff0000) {
		fprintf(stderr, "ERROR: polynomial is too large, sucka.\n");
		return 0;
	}
	
	printf("//! CRC 0%o table, as generated by crc_table.cpp\n", poly);
	printf("static uint16 crc_table[256] = { \n");
	for (int n = 0; n < 256; n++) {
		if (n%8 == 0)
			printf("    ");
		crc = n << 8;
		for (int i = 0; i < 8; i++) {
			if (crc & 0x8000)
				crc = (crc << 1) ^ poly;
			else
				crc <<= 1;
			crc &= 0xffff;
		}
		printf("0x%04x%s ", crc, (n != 255 ? "," : ""));
		if (n%8 == 7)
			printf("\n");
	}
	printf("};\n");
	return 0;
}
