#ifndef __VTERM_INPUT_H__
#define __VTERM_INPUT_H__

typedef enum {
  VTERM_MOD_NONE  = 0x00,
  VTERM_MOD_SHIFT = 0x01,
  VTERM_MOD_ALT   = 0x02,
  VTERM_MOD_CTRL  = 0x04,
} VTermModifier;

typedef enum {
  VTERM_KEY_NONE,

  VTERM_KEY_ENTER,
  VTERM_KEY_TAB,
  VTERM_KEY_BACKSPACE,
  VTERM_KEY_ESCAPE,

  VTERM_KEY_UP,
  VTERM_KEY_DOWN,
  VTERM_KEY_LEFT,
  VTERM_KEY_RIGHT,

  VTERM_KEY_INS,
  VTERM_KEY_DEL,
  VTERM_KEY_HOME,
  VTERM_KEY_END,
  VTERM_KEY_PAGEUP,
  VTERM_KEY_PAGEDOWN,

  VTERM_KEY_FUNCTION_0,
  VTERM_KEY_FUNCTION_MAX = VTERM_KEY_FUNCTION_0 + 255,

  VTERM_KEY_MAX, // Must be last
} VTermKey;

#define VTERM_KEY_FUNCTION(n) (VTERM_KEY_FUNCTION_0+(n))

#endif
