/*
 * Copyright 2011, The Haiku Project. All rights reserved.
 * Distributed under the terms of the MIT License.
 *
 * Authors:
 *		Artwork: Michele Frau (a.k.a. zuMi)
 *		Stephan Aßmus <superstippi@gmx.de>
 */


#include "ToolBarIcons.h"

#include <new>
#include <stdio.h>
#include <string.h>

#include <Bitmap.h>
#include <IconUtils.h>


static const uint8 kDocumentOpen[] = {
	0x6e, 0x63, 0x69, 0x66, 0x06, 0x04, 0x00, 0x66, 0x03, 0xbf, 0x50, 0x00,
	0x03, 0x00, 0x00, 0x80, 0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3a,
	0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x49,
	0xc0, 0x00, 0x00, 0xff, 0xea, 0x80, 0xff, 0xff, 0xbb, 0x00, 0x02, 0x00,
	0x06, 0x02, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xd9, 0xd9, 0xff, 0x03, 0xff, 0xc8, 0x00, 0x03, 0x0a, 0x06, 0x24,
	0x46, 0x46, 0x46, 0x44, 0x24, 0x3c, 0x24, 0x3a, 0x28, 0x26, 0x28, 0x0a,
	0x04, 0xb4, 0x97, 0x46, 0xb3, 0xcb, 0x36, 0x48, 0x36, 0x46, 0x46, 0x08,
	0x04, 0x24, 0x34, 0x24, 0x2c, 0x46, 0x2c, 0x46, 0x34, 0x07, 0x0a, 0x00,
	0x03, 0x00, 0x01, 0x02, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x05,
	0x01, 0x00, 0x00, 0x0a, 0x02, 0x01, 0x02, 0x10, 0x01, 0x17, 0x83, 0x22,
	0x04, 0x0a, 0x04, 0x01, 0x02, 0x00, 0x0a, 0x01, 0x01, 0x01, 0x10, 0x01,
	0x17, 0x83, 0x22, 0x04, 0x0a, 0x03, 0x01, 0x01, 0x00
};


static const uint8 kDocumentSaveAs[] = {
	0x6e, 0x63, 0x69, 0x66, 0x09, 0x04, 0x00, 0x66, 0x05, 0x00, 0x02, 0x00,
	0x16, 0x02, 0x00, 0x00, 0x00, 0x3a, 0x40, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x49, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xe6,
	0x02, 0x00, 0x16, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xab,
	0xff, 0x40, 0x05, 0x80, 0x02, 0x00, 0x16, 0x02, 0x00, 0x00, 0x00, 0x39,
	0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x46,
	0x00, 0x00, 0x00, 0xf7, 0xff, 0xcc, 0x03, 0xd9, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x80, 0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3a, 0x40, 0x00,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xe5, 0xff, 0x0c, 0x0a, 0x05, 0x48,
	0x48, 0x22, 0x48, 0x22, 0xb3, 0xcb, 0x44, 0xb3, 0xcb, 0x48, 0x26, 0x0a,
	0x04, 0x28, 0x36, 0x42, 0x36, 0x42, 0x48, 0x28, 0x48, 0x0a, 0x04, 0x26,
	0xb3, 0xcb, 0x2e, 0xb3, 0xcb, 0x2e, 0x30, 0x26, 0x30, 0x0a, 0x04, 0x2e,
	0xb3, 0xcb, 0x42, 0xb3, 0xcb, 0x42, 0x2e, 0x2e, 0x2e, 0x0a, 0x04, 0x3a,
	0x24, 0x3e, 0x24, 0x3e, 0x2c, 0x3a, 0x2c, 0x0a, 0x04, 0x2a, 0x44, 0x40,
	0x44, 0x42, 0x48, 0x28, 0x48, 0x0a, 0x07, 0x22, 0x2c, 0x48, 0x2c, 0x48,
	0x3e, 0x3c, 0x3e, 0x35, 0x43, 0x2e, 0x3e, 0x22, 0x3e, 0x06, 0x12, 0xfe,
	0x44, 0xf4, 0x13, 0x01, 0x32, 0x3c, 0x34, 0x3c, 0x34, 0x3c, 0xbb, 0x2b,
	0x3c, 0x35, 0x3a, 0x35, 0x3b, 0x35, 0x3b, 0x36, 0x3c, 0xbb, 0x91, 0x3c,
	0x36, 0x3c, 0x38, 0x3a, 0x36, 0x30, 0x38, 0x2e, 0x36, 0x2e, 0x36, 0x2e,
	0xbb, 0x91, 0x2e, 0x35, 0x30, 0x35, 0x2f, 0x35, 0x2f, 0x34, 0x2e, 0xbb,
	0x2b, 0x2e, 0x34, 0x2e, 0x32, 0x30, 0x34, 0x3a, 0x32, 0x04, 0x04, 0xfe,
	0x29, 0x3a, 0x29, 0x34, 0x29, 0x34, 0x29, 0x33, 0x27, 0x32, 0x28, 0x32,
	0x26, 0x32, 0x25, 0x34, 0x25, 0x33, 0x25, 0x34, 0x04, 0x05, 0xfe, 0x00,
	0x29, 0x38, 0x26, 0x39, 0x27, 0x39, 0xb4, 0xf4, 0x39, 0x25, 0x37, 0x25,
	0x38, 0x25, 0x36, 0x27, 0x35, 0x26, 0x35, 0x27, 0x35, 0x29, 0x04, 0x05,
	0xfe, 0x00, 0x2d, 0x38, 0x2f, 0x39, 0x2e, 0x39, 0x30, 0x39, 0x31, 0x37,
	0x31, 0x38, 0x31, 0x36, 0x2f, 0x35, 0x30, 0x35, 0x2f, 0x35, 0x2d, 0x08,
	0x02, 0x2d, 0x3a, 0x2d, 0x30, 0x0e, 0x0a, 0x00, 0x01, 0x00, 0x30, 0x22,
	0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x10, 0x01,
	0x17, 0x83, 0x22, 0x04, 0x0a, 0x03, 0x01, 0x00, 0x00, 0x0a, 0x01, 0x01,
	0x01, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02, 0x01, 0x01, 0x00,
	0x0a, 0x04, 0x01, 0x02, 0x00, 0x0a, 0x01, 0x01, 0x03, 0x10, 0x01, 0x17,
	0x83, 0x22, 0x04, 0x0a, 0x05, 0x01, 0x03, 0x00, 0x0a, 0x01, 0x01, 0x04,
	0x00, 0x0a, 0x06, 0x01, 0x05, 0x00, 0x0a, 0x07, 0x01, 0x06, 0x10, 0x01,
	0x17, 0x84, 0x22, 0x04, 0x0a, 0x08, 0x01, 0x06, 0x00, 0x0a, 0x07, 0x01,
	0x07, 0x00, 0x0a, 0x01, 0x04, 0x08, 0x09, 0x0b, 0x0a, 0x10, 0x01, 0x17,
	0x82, 0x00, 0x04
};


static const uint8 kDocumentSave[] = {
	0x6e, 0x63, 0x69, 0x66, 0x07, 0x04, 0x00, 0x66, 0x05, 0x00, 0x02, 0x00,
	0x16, 0x02, 0x00, 0x00, 0x00, 0x3a, 0x40, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x49, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xe6,
	0x02, 0x00, 0x16, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xab,
	0xff, 0x40, 0x05, 0x80, 0x02, 0x00, 0x16, 0x02, 0x00, 0x00, 0x00, 0x39,
	0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x46,
	0x00, 0x00, 0x00, 0xf7, 0xff, 0xcc, 0x03, 0xd9, 0x00, 0x00, 0x06, 0x0a,
	0x05, 0x48, 0x48, 0x22, 0x48, 0x22, 0xb3, 0xcb, 0x44, 0xb3, 0xcb, 0x48,
	0x26, 0x0a, 0x04, 0x28, 0x36, 0x42, 0x36, 0x42, 0x48, 0x28, 0x48, 0x0a,
	0x04, 0x26, 0xb3, 0xcb, 0x2e, 0xb3, 0xcb, 0x2e, 0x30, 0x26, 0x30, 0x0a,
	0x04, 0x2e, 0xb3, 0xcb, 0x42, 0xb3, 0xcb, 0x42, 0x2e, 0x2e, 0x2e, 0x0a,
	0x04, 0x3a, 0x24, 0x3e, 0x24, 0x3e, 0x2c, 0x3a, 0x2c, 0x0a, 0x04, 0x2a,
	0x44, 0x40, 0x44, 0x42, 0x48, 0x28, 0x48, 0x0a, 0x0a, 0x00, 0x01, 0x00,
	0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x01, 0x01, 0x00,
	0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x03, 0x01, 0x00, 0x00, 0x0a,
	0x01, 0x01, 0x01, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02, 0x01,
	0x01, 0x00, 0x0a, 0x04, 0x01, 0x02, 0x00, 0x0a, 0x01, 0x01, 0x03, 0x10,
	0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x05, 0x01, 0x03, 0x00, 0x0a, 0x01,
	0x01, 0x04, 0x00, 0x0a, 0x06, 0x01, 0x05, 0x00
};


static const uint8 kDrawRectangularSelection[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x05, 0x54, 0x05, 0xff,
	0x02, 0x08, 0x02, 0x25, 0x23, 0x23, 0x23, 0x08, 0x02, 0x23, 0x25, 0x23,
	0x23, 0x24, 0x0a, 0x00, 0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x86,
	0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x86, 0x22, 0x04,
	0x0a, 0x02, 0x01, 0x00, 0x10, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x00, 0x30, 0x2e, 0x22, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x00, 0x30, 0x2c, 0x20, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x30, 0x2c, 0x20, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x00, 0x30, 0x3a, 0x22, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x00, 0x30, 0x38, 0x20, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x30, 0x38, 0x20, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x00, 0x30, 0x2c, 0x46, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x00, 0x30, 0x2a, 0x44, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x30, 0x2a, 0x44, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x00, 0x30, 0x38, 0x46, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x00, 0x30, 0x36, 0x44, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x30, 0x36, 0x44, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x00, 0x30, 0x44, 0x46, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x00, 0x30, 0x42, 0x44, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x30, 0x42, 0x44, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x01, 0x30, 0x22, 0x2c, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x01, 0x30, 0x20, 0x2a, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x01, 0x30, 0x20, 0x2a, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x01, 0x30, 0x22, 0x38, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x01, 0x30, 0x20, 0x36, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x01, 0x30, 0x20, 0x36, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x01, 0x30, 0x22, 0x44, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x01, 0x30, 0x20, 0x42, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x01, 0x30, 0x20, 0x42, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x01, 0x30, 0x46, 0x22, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x01, 0x30, 0x44, 0x20, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x01, 0x30, 0x44, 0x20, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x01, 0x30, 0x46, 0x2e, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x01, 0x30, 0x44, 0x2c, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x01, 0x30, 0x44, 0x2c, 0x01, 0x17, 0x82, 0x22, 0x04, 0x0a, 0x00,
	0x01, 0x01, 0x30, 0x46, 0x3a, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x01, 0x30, 0x44, 0x38, 0x01, 0x17, 0x86, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x01, 0x30, 0x44, 0x38, 0x01, 0x17, 0x82, 0x22, 0x04
};


static const uint8 kEditCopy[] = {
	0x6e, 0x63, 0x69, 0x66, 0x05, 0x04, 0x00, 0x66, 0x03, 0xd9, 0x91, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3b, 0xc0, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x49, 0x20, 0x00, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x03, 0x00, 0x00, 0x80, 0x02, 0x00,
	0x06, 0x02, 0x00, 0x00, 0x00, 0x3b, 0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x49, 0x20, 0x00, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xd9, 0xd9, 0xff, 0x03, 0x0a, 0x04, 0x30, 0x2a, 0x48, 0x2a, 0x48,
	0x48, 0x30, 0x48, 0x0a, 0x04, 0x34, 0x2e, 0x44, 0x2e, 0x44, 0x30, 0x34,
	0x30, 0x0a, 0x04, 0x34, 0x34, 0x42, 0x34, 0x42, 0x36, 0x34, 0x36, 0x0a,
	0x0a, 0x00, 0x01, 0x00, 0x30, 0x14, 0x1a, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x01, 0x01, 0x00, 0x30, 0x12, 0x18, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x02, 0x01, 0x00, 0x20, 0x12, 0x18, 0x0a, 0x01, 0x02, 0x02, 0x01,
	0x20, 0x12, 0x18, 0x0a, 0x01, 0x02, 0x02, 0x01, 0x20, 0x12, 0x24, 0x0a,
	0x00, 0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a,
	0x03, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x04, 0x01,
	0x00, 0x00, 0x0a, 0x03, 0x02, 0x01, 0x02, 0x00, 0x0a, 0x03, 0x02, 0x02,
	0x01, 0x20, 0x20, 0x2c
};


static const uint8 kEditCut[] = {
	0x6e, 0x63, 0x69, 0x66, 0x06, 0x05, 0x54, 0x03, 0x80, 0x00, 0x00, 0x02,
	0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x47, 0x7f, 0xff, 0x00, 0xe6, 0xea,
	0xf2, 0xff, 0xce, 0xd2, 0xd9, 0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00,
	0x3a, 0x40, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00,
	0x4a, 0x30, 0x00, 0x00, 0xff, 0xab, 0xab, 0xff, 0xd9, 0x00, 0x00, 0x05,
	0xff, 0x04, 0x00, 0x66, 0x04, 0x06, 0x05, 0x4b, 0x00, 0x32, 0x24, 0x32,
	0x26, 0x32, 0xb3, 0xcb, 0x30, 0x1f, 0x2e, 0x38, 0x32, 0x02, 0x04, 0x28,
	0x3c, 0xb7, 0x11, 0x3c, 0xb5, 0x4e, 0x3c, 0x24, 0x42, 0x24, 0xbf, 0x3a,
	0x24, 0xc1, 0xdd, 0x28, 0x48, 0xb5, 0x4e, 0x48, 0xb7, 0x11, 0x48, 0x2c,
	0x42, 0x2c, 0xc1, 0xdd, 0x2c, 0xbf, 0x3a, 0x02, 0x04, 0x32, 0x38, 0x32,
	0x38, 0x32, 0x3c, 0x2e, 0x42, 0x2e, 0x3e, 0x2e, 0x42, 0x2a, 0x42, 0x2a,
	0x42, 0x2a, 0x3e, 0x2e, 0x38, 0x2e, 0x3c, 0x2e, 0x38, 0x0a, 0x04, 0x30,
	0x32, 0x2e, 0x34, 0x2e, 0x1f, 0x30, 0x1f, 0x15, 0x0a, 0x05, 0x01, 0x00,
	0x12, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91, 0x3f, 0xc9,
	0x71, 0x47, 0x97, 0xb6, 0xba, 0xfe, 0xcc, 0x01, 0x17, 0x84, 0x02, 0x04,
	0x0a, 0x05, 0x01, 0x01, 0x12, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc,
	0x93, 0x91, 0x3f, 0xc9, 0x71, 0x47, 0x97, 0xb6, 0xba, 0xfe, 0xcc, 0x01,
	0x17, 0x88, 0x00, 0x04, 0x0a, 0x05, 0x01, 0x02, 0x12, 0x3f, 0xc9, 0x71,
	0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91, 0x3f, 0xc9, 0x71, 0x47, 0x97, 0xb6,
	0xba, 0xfe, 0xcc, 0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x00, 0x01, 0x00,
	0x12, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91, 0x3f, 0xc9,
	0x71, 0x47, 0x17, 0xb6, 0xc2, 0x2f, 0xec, 0x01, 0x17, 0x84, 0x02, 0x04,
	0x0a, 0x01, 0x01, 0x01, 0x12, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc,
	0x93, 0x91, 0x3f, 0xc9, 0x71, 0x47, 0x17, 0xb6, 0xc2, 0x2f, 0xec, 0x01,
	0x17, 0x88, 0x00, 0x04, 0x0a, 0x01, 0x01, 0x02, 0x12, 0x3f, 0xc9, 0x71,
	0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91, 0x3f, 0xc9, 0x71, 0x47, 0x17, 0xb6,
	0xc2, 0x2f, 0xec, 0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x02, 0x01, 0x00,
	0x02, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91, 0x3f, 0xc9,
	0x71, 0x47, 0x17, 0xb6, 0xc2, 0x2f, 0xec, 0x0a, 0x03, 0x01, 0x01, 0x12,
	0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91, 0x3f, 0xc9, 0x71,
	0x47, 0x17, 0xb6, 0xc2, 0x2f, 0xec, 0x01, 0x17, 0x83, 0x00, 0x04, 0x0a,
	0x03, 0x01, 0x02, 0x02, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc, 0x93,
	0x91, 0x3f, 0xc9, 0x71, 0x47, 0x17, 0xb6, 0xc2, 0x2f, 0xec, 0x0a, 0x04,
	0x01, 0x03, 0x02, 0x3f, 0xc9, 0x71, 0x3c, 0x93, 0x91, 0xbc, 0x93, 0x91,
	0x3f, 0xc9, 0x71, 0x47, 0x17, 0xb6, 0xc2, 0x2f, 0xec, 0x0a, 0x00, 0x00,
	0x20, 0xb4, 0xe4, 0xb2, 0xf3, 0x0a, 0x05, 0x01, 0x00, 0x12, 0xbf, 0xc9,
	0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95, 0x49, 0x64,
	0x70, 0xba, 0xf9, 0xaa, 0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x05, 0x01,
	0x01, 0x12, 0xbf, 0xc9, 0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f,
	0xc9, 0x95, 0x49, 0x64, 0x70, 0xba, 0xf9, 0xaa, 0x01, 0x17, 0x88, 0x00,
	0x04, 0x0a, 0x05, 0x01, 0x02, 0x12, 0xbf, 0xc9, 0x85, 0x3c, 0x92, 0xb1,
	0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95, 0x49, 0x64, 0x70, 0xba, 0xf9, 0xaa,
	0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x00, 0x01, 0x00, 0x12, 0xbf, 0xc9,
	0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95, 0x49, 0x24,
	0x70, 0xc2, 0x2f, 0x9a, 0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x01, 0x01,
	0x01, 0x12, 0xbf, 0xc9, 0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f,
	0xc9, 0x95, 0x49, 0x24, 0x70, 0xc2, 0x2f, 0x9a, 0x01, 0x17, 0x88, 0x00,
	0x04, 0x0a, 0x01, 0x01, 0x02, 0x12, 0xbf, 0xc9, 0x85, 0x3c, 0x92, 0xb1,
	0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95, 0x49, 0x24, 0x70, 0xc2, 0x2f, 0x9a,
	0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x02, 0x01, 0x00, 0x02, 0xbf, 0xc9,
	0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95, 0x49, 0x24,
	0x70, 0xc2, 0x2f, 0x9a, 0x0a, 0x03, 0x01, 0x01, 0x12, 0xbf, 0xc9, 0x85,
	0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95, 0x49, 0x24, 0x70,
	0xc2, 0x2f, 0x9a, 0x01, 0x17, 0x83, 0x00, 0x04, 0x0a, 0x03, 0x01, 0x02,
	0x02, 0xbf, 0xc9, 0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f, 0xc9,
	0x95, 0x49, 0x24, 0x70, 0xc2, 0x2f, 0x9a, 0x0a, 0x04, 0x01, 0x03, 0x02,
	0xbf, 0xc9, 0x85, 0x3c, 0x92, 0xb1, 0x3c, 0x92, 0xbb, 0x3f, 0xc9, 0x95,
	0x49, 0x24, 0x70, 0xc2, 0x2f, 0x9a
};


const unsigned char kEditDelete[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x03, 0x80, 0x00, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x20, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xe0, 0x00, 0x00, 0xff,
	0xab, 0xab, 0xff, 0xd9, 0x00, 0x00, 0x01, 0x0a, 0x0c, 0x48, 0x2a, 0x40,
	0x22, 0x35, 0x2d, 0x2a, 0x22, 0x22, 0x2a, 0x2d, 0x35, 0x22, 0x40, 0x2a,
	0x48, 0x35, 0x3d, 0x40, 0x48, 0x48, 0x40, 0x3d, 0x35, 0x03, 0x0a, 0x00,
	0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x01,
	0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02, 0x01, 0x00,
	0x00
};


static const uint8 kEditTrash[] = {
	0x6e, 0x63, 0x69, 0x66, 0x05, 0x04, 0x00, 0x66, 0x05, 0x00, 0x03, 0x08,
	0x59, 0x3e, 0x02, 0x00, 0x16, 0x02, 0x00, 0x00, 0x00, 0x37, 0x00, 0x00,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x44, 0x80, 0x00,
	0x00, 0x80, 0xff, 0x28, 0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3b,
	0xc0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x49,
	0x20, 0x00, 0x00, 0x73, 0xe5, 0xbe, 0xff, 0x11, 0xb2, 0x7b, 0x02, 0x0a,
	0x04, 0x42, 0x48, 0x46, 0x2a, 0x24, 0x2a, 0x28, 0x48, 0x0a, 0x04, 0x48,
	0x2a, 0x48, 0x22, 0x22, 0x22, 0x22, 0x2a, 0x05, 0x0a, 0x00, 0x02, 0x00,
	0x01, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x01, 0x01,
	0x01, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02, 0x01, 0x00, 0x10,
	0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x04,
	0x01, 0x00, 0x00
};


static const uint8 kGoDown[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x03, 0xbf, 0x50, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xff,
	0xff, 0x80, 0xff, 0xff, 0xd5, 0x00, 0x01, 0x0a, 0x07, 0x35, 0x48, 0x22,
	0x34, 0x2c, 0x34, 0x2c, 0xb3, 0xcb, 0x3e, 0xb3, 0xcb, 0x3e, 0x34, 0x48,
	0x34, 0x03, 0x0a, 0x00, 0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83,
	0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x02, 0x01, 0x00, 0x00
};


const unsigned char kGoNext[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x03, 0x00, 0x59, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0x80,
	0xff, 0x80, 0xff, 0x00, 0xb3, 0x00, 0x01, 0x0a, 0x07, 0x48, 0x35, 0x34,
	0x48, 0x34, 0x3e, 0x22, 0x3e, 0x22, 0x2c, 0x34, 0x2c, 0x34, 0x22, 0x03,
	0x0a, 0x00, 0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x00
};


const unsigned char kGoPrevious[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x03, 0x00, 0x59, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0x80,
	0xff, 0x80, 0xff, 0x00, 0xb3, 0x00, 0x01, 0x0a, 0x07, 0x22, 0x35, 0x36,
	0x22, 0x36, 0x2c, 0x48, 0x2c, 0x48, 0x3e, 0x36, 0x3e, 0x36, 0x48, 0x03,
	0x0a, 0x00, 0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x00
};


static const uint8 kGoUp[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x03, 0xbf, 0x50, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xff,
	0xff, 0x80, 0xff, 0xff, 0xd5, 0x00, 0x01, 0x0a, 0x07, 0x35, 0x22, 0x48,
	0x36, 0x3e, 0x36, 0x3e, 0x48, 0x2c, 0x48, 0x2c, 0x36, 0x22, 0x36, 0x03,
	0x0a, 0x00, 0x01, 0x00, 0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04,
	0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x02,
	0x01, 0x00, 0x00
};


const unsigned char kMediaMovieLibraryR4[] = {
	0x6e, 0x63, 0x69, 0x66, 0x06, 0x05, 0x00, 0x02, 0x00, 0x16, 0x02, 0x00,
	0x00, 0x00, 0x3a, 0x40, 0x08, 0xc0, 0x00, 0x01, 0x00, 0x00, 0x00, 0x4b,
	0xff, 0xf9, 0x49, 0xe0, 0x04, 0x00, 0x82, 0xff, 0x29, 0x02, 0x00, 0x16,
	0x02, 0x00, 0x00, 0x00, 0x39, 0x80, 0x10, 0xc0, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x4b, 0xff, 0xfd, 0x49, 0xe0, 0x04, 0x00, 0x82, 0xff, 0x29, 0x05,
	0x54, 0x02, 0x00, 0x16, 0x02, 0x00, 0x00, 0x00, 0x3a, 0x40, 0x00, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xff, 0xfb, 0x46, 0xc0, 0x00, 0x00,
	0xff, 0xff, 0xe6, 0x04, 0x00, 0x66, 0x09, 0x0a, 0x04, 0x28, 0x36, 0x42,
	0x36, 0x42, 0x48, 0x28, 0x48, 0x0a, 0x04, 0x22, 0x38, 0x22, 0x46, 0x28,
	0x42, 0x28, 0x3c, 0x02, 0x04, 0x3f, 0x22, 0xc1, 0x54, 0x22, 0xbd, 0x5f,
	0x22, 0x36, 0x2b, 0x36, 0xb5, 0x67, 0x36, 0xb9, 0x5c, 0x3f, 0x34, 0xbd,
	0x5f, 0x34, 0xc1, 0x54, 0x34, 0x48, 0x2b, 0x48, 0xb9, 0x5c, 0x48, 0xb5,
	0x67, 0x06, 0x04, 0xef, 0x46, 0x2b, 0x46, 0xb7, 0x04, 0x46, 0xb7, 0xbf,
	0xc1, 0xef, 0xb8, 0x6a, 0xc2, 0x10, 0xb8, 0x18, 0xc1, 0xef, 0xb8, 0x6a,
	0x41, 0x2b, 0xc1, 0xf0, 0xb6, 0x59, 0xc1, 0xf0, 0xb6, 0x59, 0xc2, 0x10,
	0xb6, 0xab, 0x06, 0x03, 0x3b, 0xc1, 0x88, 0xb5, 0xa9, 0xc1, 0x19, 0xb5,
	0x1d, 0xc1, 0x88, 0xb5, 0xa9, 0x40, 0xb6, 0xb1, 0x40, 0xb4, 0xa2, 0x40,
	0xb4, 0xa2, 0xc0, 0x79, 0xb4, 0xbc, 0x06, 0x03, 0x37, 0x3e, 0xb4, 0xa2,
	0xbe, 0x3a, 0xb4, 0xbc, 0x3e, 0xb4, 0xa2, 0xb6, 0xb1, 0xbd, 0x2b, 0xb5,
	0xa9, 0xbd, 0x2b, 0xb5, 0xa9, 0xbd, 0x9a, 0xb5, 0x1d, 0x06, 0x04, 0xfb,
	0xbc, 0xc4, 0xb6, 0x59, 0xbc, 0xa3, 0xb6, 0xab, 0xbc, 0xc4, 0xb6, 0x59,
	0x3d, 0x2b, 0xbc, 0xc3, 0xb8, 0x6a, 0xbc, 0xc3, 0xb8, 0x6a, 0xbc, 0xa3,
	0xb8, 0x18, 0x38, 0x2b, 0x38, 0xb7, 0xbf, 0x38, 0xb7, 0x04, 0x06, 0x03,
	0x3b, 0xbd, 0x2b, 0xb9, 0x1a, 0xbd, 0x9a, 0xb9, 0xa6, 0xbd, 0x2b, 0xb9,
	0x1a, 0x3e, 0xb8, 0x12, 0x3e, 0xba, 0x21, 0x3e, 0xba, 0x21, 0xbe, 0x3a,
	0xba, 0x06, 0x06, 0x03, 0x37, 0x40, 0xba, 0x21, 0xc0, 0x79, 0xba, 0x06,
	0x40, 0xba, 0x21, 0xb8, 0x12, 0xc1, 0x88, 0xb9, 0x1a, 0xc1, 0x88, 0xb9,
	0x1a, 0xc1, 0x19, 0xb9, 0xa6, 0x09, 0x0a, 0x05, 0x03, 0x00, 0x01, 0x02,
	0x30, 0x22, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x05, 0x01, 0x02,
	0x30, 0x0e, 0x22, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x00, 0x02, 0x00,
	0x01, 0x10, 0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x00,
	0x0a, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x07, 0x08, 0x07, 0x06, 0x05,
	0x04, 0x03, 0x02, 0x10, 0x01, 0x17, 0x83, 0x00, 0x04, 0x0a, 0x04, 0x07,
	0x02, 0x03, 0x07, 0x08, 0x05, 0x06, 0x04, 0x00, 0x0a, 0x03, 0x07, 0x08,
	0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x30, 0x0c, 0x20, 0x01, 0x17, 0x83,
	0x00, 0x04, 0x0a, 0x04, 0x07, 0x02, 0x03, 0x07, 0x08, 0x05, 0x06, 0x04,
	0x20, 0x0c, 0x20
};


const unsigned char kMediaPlaybackStartEnabled[] = {
	0x6e, 0x63, 0x69, 0x66, 0x03, 0x04, 0x00, 0x66, 0x03, 0x00, 0x59, 0x00,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0x80,
	0xff, 0x80, 0xff, 0x00, 0xb2, 0x00, 0x01, 0x0a, 0x03, 0x46, 0x35, 0x24,
	0xb3, 0xcb, 0x24, 0x48, 0x03, 0x0a, 0x00, 0x01, 0x00, 0x30, 0x22, 0x22,
	0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17,
	0x83, 0x22, 0x04, 0x0a, 0x02, 0x01, 0x00, 0x00
};


static const uint8 kViewFullScreen[] = {
	0x6e, 0x63, 0x69, 0x66, 0x07, 0x04, 0x00, 0x66, 0x03, 0xbf, 0x50, 0x00,
	0x03, 0xff, 0xd4, 0x00, 0x02, 0x02, 0x06, 0x02, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xc0, 0x00, 0x48, 0xc0, 0x00, 0x48,
	0xe0, 0x00, 0xab, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xe1, 0xdc, 0x05, 0x54,
	0x02, 0x02, 0x06, 0x02, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xb9, 0x00, 0x00, 0x46, 0x00, 0x00, 0x46, 0x00, 0x00, 0xff, 0x80,
	0xaa, 0xff, 0x00, 0x00, 0x47, 0xd9, 0x03, 0x00, 0x2a, 0x80, 0x03, 0x0a,
	0x04, 0x2a, 0x2c, 0x2a, 0x28, 0x34, 0x28, 0x34, 0x2c, 0x0a, 0x04, 0x42,
	0x42, 0x2a, 0x42, 0x2a, 0x2c, 0x42, 0x2c, 0x0a, 0x03, 0x22, 0x22, 0x2c,
	0x22, 0x22, 0x2c, 0x0d, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x22, 0x22,
	0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x04, 0x01, 0x01, 0x10, 0x01, 0x17,
	0x84, 0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22,
	0x04, 0x0a, 0x02, 0x01, 0x00, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x0a,
	0x06, 0x01, 0x02, 0x12, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc0, 0x00, 0x00, 0x4a, 0xc0, 0x00, 0x4a, 0xc0, 0x00, 0x01, 0x17,
	0x84, 0x22, 0x04, 0x0a, 0x06, 0x01, 0x02, 0x12, 0x00, 0x00, 0x00, 0x40,
	0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xc0, 0x00, 0x37,
	0x6c, 0x80, 0x01, 0x17, 0x84, 0x22, 0x04, 0x0a, 0x06, 0x01, 0x02, 0x30,
	0xb3, 0x05, 0xb3, 0x05, 0x01, 0x17, 0x84, 0x22, 0x04, 0x0a, 0x06, 0x01,
	0x02, 0x12, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x37, 0x6c, 0x89, 0x4a, 0xbf, 0xff, 0x01, 0x17, 0x84, 0x22,
	0x04, 0x0a, 0x05, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x61, 0xfd, 0x4a, 0xc0, 0x00,
	0x0a, 0x05, 0x01, 0x02, 0x00, 0x0a, 0x05, 0x01, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x40, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x05, 0x01, 0x02, 0x02, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x4a, 0xc0, 0x00,
	0x4a, 0xc0, 0x00
};


static const uint8 kViewWindowed[] = {
	0x6e, 0x63, 0x69, 0x66, 0x07, 0x04, 0x00, 0x66, 0x03, 0xbf, 0x50, 0x00,
	0x03, 0xff, 0xd4, 0x00, 0x05, 0x54, 0x02, 0x02, 0x06, 0x02, 0x3b, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00, 0x48, 0x00,
	0x00, 0x48, 0x40, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xe1, 0xdc,
	0x03, 0x00, 0x40, 0x80, 0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x39,
	0x80, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xe0, 0x00, 0x47,
	0x40, 0x00, 0x00, 0xab, 0xd5, 0xff, 0xff, 0x00, 0x6c, 0xd9, 0x03, 0x0a,
	0x04, 0x22, 0x26, 0x22, 0x22, 0x2e, 0x22, 0x2e, 0x26, 0x0a, 0x04, 0x3e,
	0x3c, 0x22, 0x3c, 0x22, 0x26, 0x3e, 0x26, 0x0a, 0x07, 0x46, 0x2e, 0x3c,
	0x2e, 0x3c, 0x24, 0x3f, 0x27, 0x44, 0x22, 0x48, 0x26, 0x43, 0x2b, 0x0b,
	0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x26, 0x26, 0x01, 0x17, 0x84, 0x22,
	0x04, 0x0a, 0x03, 0x01, 0x01, 0x30, 0x24, 0x24, 0x01, 0x17, 0x84, 0x22,
	0x04, 0x0a, 0x01, 0x01, 0x00, 0x30, 0x24, 0x24, 0x01, 0x17, 0x84, 0x22,
	0x04, 0x0a, 0x02, 0x01, 0x00, 0x20, 0x24, 0x24, 0x0a, 0x04, 0x01, 0x01,
	0x20, 0x24, 0x24, 0x0a, 0x00, 0x01, 0x02, 0x30, 0x22, 0x22, 0x01, 0x17,
	0x84, 0x22, 0x04, 0x0a, 0x05, 0x01, 0x02, 0x10, 0x01, 0x17, 0x84, 0x22,
	0x04, 0x0a, 0x06, 0x01, 0x02, 0x00, 0x0a, 0x00, 0x01, 0x02, 0x12, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x4a,
	0xbe, 0xe8, 0x4a, 0xc1, 0x17, 0x01, 0x17, 0x84, 0x22, 0x04, 0x0a, 0x05,
	0x01, 0x02, 0x12, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x00, 0x00, 0x4a, 0x9e, 0xe8, 0x4a, 0xa1, 0x17, 0x01, 0x17, 0x84,
	0x22, 0x04, 0x0a, 0x06, 0x01, 0x02, 0x02, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x4a, 0x9e, 0xe8, 0x4a, 0xa1,
	0x17
};


static const uint8 kZoomFitBest[] = {
	0x6e, 0x63, 0x69, 0x66, 0x05, 0x04, 0x00, 0x66, 0x05, 0x54, 0x02, 0x00,
	0x16, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x80, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0x80, 0x00, 0x00, 0xff, 0xff, 0xe5,
	0x03, 0x20, 0x59, 0xce, 0x02, 0x01, 0x06, 0x02, 0x3a, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x80, 0x00, 0x47, 0xbf, 0xff, 0x47,
	0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xea, 0xfa, 0x04, 0x08,
	0x02, 0x46, 0x46, 0x3f, 0x3f, 0x02, 0x04, 0x40, 0x32, 0x40, 0xbd, 0x40,
	0x40, 0xb7, 0x17, 0x32, 0x24, 0xbd, 0x40, 0x24, 0xb7, 0x17, 0x24, 0x24,
	0x32, 0x24, 0xb7, 0x17, 0x24, 0xbd, 0x40, 0x32, 0x40, 0xb7, 0x17, 0x40,
	0xbd, 0x40, 0x40, 0x02, 0x04, 0x32, 0x28, 0xbc, 0x5f, 0x28, 0xb7, 0xf8,
	0x28, 0x28, 0x32, 0x28, 0xb7, 0xf8, 0x28, 0xbc, 0x5f, 0x32, 0x3c, 0xb7,
	0xf8, 0x3c, 0xbc, 0x5f, 0x3c, 0x3c, 0x32, 0x3c, 0xbc, 0x5f, 0x3c, 0xb7,
	0xf8, 0x0a, 0x06, 0x2b, 0x2b, 0x31, 0x2c, 0x2e, 0x2d, 0x31, 0x31, 0x2d,
	0x2e, 0x2c, 0x31, 0x09, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x22, 0x22,
	0x01, 0x17, 0x88, 0x22, 0x04, 0x0a, 0x01, 0x02, 0x00, 0x01, 0x10, 0x01,
	0x17, 0x88, 0x22, 0x04, 0x0a, 0x02, 0x02, 0x00, 0x01, 0x10, 0x01, 0x17,
	0x84, 0x20, 0x04, 0x0a, 0x03, 0x01, 0x02, 0x10, 0x01, 0x17, 0x84, 0x00,
	0x04, 0x0a, 0x04, 0x01, 0x02, 0x00, 0x0a, 0x03, 0x01, 0x03, 0x00, 0x0a,
	0x03, 0x01, 0x03, 0x02, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc0, 0x00, 0x00, 0x4a, 0x40, 0x00, 0x4a, 0x40, 0x00, 0x0a, 0x03,
	0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x40, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x0e, 0xcc, 0x4a, 0x40, 0x00, 0x0a, 0x03, 0x01,
	0x03, 0x02, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4a, 0x40, 0x00, 0x08, 0x0e, 0xcc
};


static const uint8 kZoomFitViewBest[] = {
	0x6e, 0x63, 0x69, 0x66, 0x07, 0x04, 0x00, 0x66, 0x03, 0xbf, 0x50, 0x00,
	0x03, 0xff, 0xd4, 0x00, 0x02, 0x02, 0x06, 0x02, 0x3c, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x80, 0x00, 0x48, 0xa0, 0x00, 0x49,
	0x20, 0x00, 0xca, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xe1, 0xdc, 0x05, 0x54,
	0x02, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x3b, 0x40, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x49, 0x20, 0x00, 0x00, 0xab,
	0xd5, 0xff, 0xff, 0x00, 0x6c, 0xd9, 0x03, 0x00, 0x40, 0x80, 0x04, 0x0a,
	0x04, 0x22, 0x2a, 0x22, 0x22, 0x2e, 0x22, 0x2e, 0x2a, 0x0a, 0x04, 0x48,
	0x48, 0x22, 0x48, 0x22, 0x2a, 0x48, 0x2a, 0x0a, 0x0a, 0x2a, 0x38, 0x40,
	0x38, 0x40, 0x34, 0x46, 0x39, 0x40, 0x3e, 0x40, 0x3a, 0x2a, 0x3a, 0x2a,
	0x3e, 0x24, 0x39, 0x2a, 0x34, 0x0a, 0x0a, 0x36, 0x32, 0x36, 0x40, 0x3a,
	0x40, 0x35, 0x46, 0x30, 0x40, 0x34, 0x40, 0x34, 0x32, 0x30, 0x32, 0x35,
	0x2c, 0x3a, 0x32, 0x07, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x22, 0x22,
	0x01, 0x17, 0x83, 0x22, 0x04, 0x0a, 0x04, 0x01, 0x01, 0x10, 0x01, 0x17,
	0x84, 0x22, 0x04, 0x0a, 0x01, 0x01, 0x00, 0x10, 0x01, 0x17, 0x83, 0x22,
	0x04, 0x0a, 0x02, 0x01, 0x00, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x0a,
	0x06, 0x02, 0x02, 0x03, 0x30, 0xb3, 0x05, 0xb3, 0x05, 0x01, 0x17, 0x84,
	0x22, 0x04, 0x0a, 0x05, 0x02, 0x02, 0x03, 0x00
};


static const uint8 kZoomIn[] = {
	0x6e, 0x63, 0x69, 0x66, 0x05, 0x04, 0x00, 0x66, 0x05, 0x54, 0x02, 0x00,
	0x16, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xff, 0xff, 0xe5,
	0x03, 0x21, 0x5a, 0xce, 0x02, 0x01, 0x06, 0x02, 0x3a, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x80, 0x00, 0x47, 0xc0, 0x00, 0x47,
	0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xea, 0xfa, 0x04, 0x08,
	0x02, 0x46, 0x46, 0x41, 0x41, 0x02, 0x04, 0x32, 0x24, 0xbd, 0x40, 0x24,
	0xb7, 0x17, 0x24, 0x24, 0x32, 0x24, 0xb7, 0x17, 0x24, 0xbd, 0x40, 0x32,
	0x40, 0xb7, 0x17, 0x40, 0xbd, 0x40, 0x40, 0x40, 0x32, 0x40, 0xbd, 0x40,
	0x40, 0xb7, 0x17, 0x02, 0x04, 0x32, 0x28, 0xbc, 0x5f, 0x28, 0xb7, 0xf8,
	0x28, 0x28, 0x32, 0x28, 0xb7, 0xf8, 0x28, 0xbc, 0x5f, 0x32, 0x3c, 0xb7,
	0xf8, 0x3c, 0xbc, 0x5f, 0x3c, 0x3c, 0x32, 0x3c, 0xbc, 0x5f, 0x3c, 0xb7,
	0xf8, 0x0a, 0x0c, 0x30, 0x34, 0x2c, 0x34, 0x2c, 0x30, 0x30, 0x30, 0x30,
	0x2c, 0x34, 0x2c, 0x34, 0x30, 0x38, 0x30, 0x38, 0x34, 0x34, 0x34, 0x34,
	0x38, 0x30, 0x38, 0x06, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x22, 0x22,
	0x01, 0x17, 0x88, 0x22, 0x04, 0x0a, 0x01, 0x02, 0x00, 0x01, 0x10, 0x01,
	0x17, 0x88, 0x22, 0x04, 0x0a, 0x02, 0x02, 0x00, 0x01, 0x10, 0x01, 0x17,
	0x84, 0x20, 0x04, 0x0a, 0x03, 0x01, 0x02, 0x10, 0x01, 0x17, 0x84, 0x00,
	0x04, 0x0a, 0x04, 0x01, 0x02, 0x00, 0x0a, 0x03, 0x01, 0x03, 0x00
};


static const uint8 kZoomOriginal[] = {
	0x6e, 0x63, 0x69, 0x66, 0x05, 0x04, 0x00, 0x66, 0x05, 0x54, 0x02, 0x00,
	0x16, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xff, 0xff, 0xe5,
	0x03, 0x21, 0x5a, 0xce, 0x02, 0x01, 0x06, 0x02, 0x3a, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x80, 0x00, 0x47, 0xc0, 0x00, 0x47,
	0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xea, 0xfa, 0x04, 0x08,
	0x02, 0x46, 0x46, 0x41, 0x41, 0x02, 0x04, 0x32, 0x24, 0xbd, 0x40, 0x24,
	0xb7, 0x17, 0x24, 0x24, 0x32, 0x24, 0xb7, 0x17, 0x24, 0xbd, 0x40, 0x32,
	0x40, 0xb7, 0x17, 0x40, 0xbd, 0x40, 0x40, 0x40, 0x32, 0x40, 0xbd, 0x40,
	0x40, 0xb7, 0x17, 0x02, 0x04, 0x32, 0x28, 0xbc, 0x5f, 0x28, 0xb7, 0xf8,
	0x28, 0x28, 0x32, 0x28, 0xb7, 0xf8, 0x28, 0xbc, 0x5f, 0x32, 0x3c, 0xb7,
	0xf8, 0x3c, 0xbc, 0x5f, 0x3c, 0x3c, 0x32, 0x3c, 0xbc, 0x5f, 0x3c, 0xb7,
	0xf8, 0x06, 0x0c, 0xd2, 0x11, 0x11, 0x30, 0x32, 0x2e, 0x30, 0x30, 0x2c,
	0x30, 0x30, 0x30, 0x2c, 0x2c, 0x34, 0x36, 0x36, 0x38, 0x2e, 0x36, 0x30,
	0x06, 0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x22, 0x22, 0x01, 0x17, 0x88,
	0x22, 0x04, 0x0a, 0x01, 0x02, 0x00, 0x01, 0x10, 0x01, 0x17, 0x88, 0x22,
	0x04, 0x0a, 0x02, 0x02, 0x00, 0x01, 0x10, 0x01, 0x17, 0x84, 0x20, 0x04,
	0x0a, 0x03, 0x01, 0x02, 0x10, 0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x04,
	0x01, 0x02, 0x00, 0x0a, 0x03, 0x01, 0x03, 0x00
};


static const uint8 kZoomOut[] = {
	0x6e, 0x63, 0x69, 0x66, 0x05, 0x04, 0x00, 0x66, 0x05, 0x54, 0x02, 0x00,
	0x16, 0x02, 0x00, 0x00, 0x00, 0x3c, 0x60, 0x00, 0xc0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x00, 0x48, 0xa0, 0x00, 0x00, 0xff, 0xff, 0xe5,
	0x03, 0x21, 0x5a, 0xce, 0x02, 0x01, 0x06, 0x02, 0x3a, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x80, 0x00, 0x47, 0xc0, 0x00, 0x47,
	0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xea, 0xfa, 0x04, 0x08,
	0x02, 0x46, 0x46, 0x41, 0x41, 0x02, 0x04, 0x32, 0x24, 0xbd, 0x40, 0x24,
	0xb7, 0x17, 0x24, 0x24, 0x32, 0x24, 0xb7, 0x17, 0x24, 0xbd, 0x40, 0x32,
	0x40, 0xb7, 0x17, 0x40, 0xbd, 0x40, 0x40, 0x40, 0x32, 0x40, 0xbd, 0x40,
	0x40, 0xb7, 0x17, 0x02, 0x04, 0x32, 0x28, 0xbc, 0x5f, 0x28, 0xb7, 0xf8,
	0x28, 0x28, 0x32, 0x28, 0xb7, 0xf8, 0x28, 0xbc, 0x5f, 0x32, 0x3c, 0xb7,
	0xf8, 0x3c, 0xbc, 0x5f, 0x3c, 0x3c, 0x32, 0x3c, 0xbc, 0x5f, 0x3c, 0xb7,
	0xf8, 0x0a, 0x04, 0x2c, 0x34, 0x2c, 0x30, 0x38, 0x30, 0x38, 0x34, 0x06,
	0x0a, 0x00, 0x02, 0x00, 0x01, 0x30, 0x22, 0x22, 0x01, 0x17, 0x88, 0x22,
	0x04, 0x0a, 0x01, 0x02, 0x00, 0x01, 0x10, 0x01, 0x17, 0x88, 0x22, 0x04,
	0x0a, 0x02, 0x02, 0x00, 0x01, 0x10, 0x01, 0x17, 0x84, 0x20, 0x04, 0x0a,
	0x03, 0x01, 0x02, 0x10, 0x01, 0x17, 0x84, 0x00, 0x04, 0x0a, 0x04, 0x01,
	0x02, 0x00, 0x0a, 0x03, 0x01, 0x03, 0x00
};


struct IconData {
	const uint8*	data;
	size_t			size;
	BBitmap*		bitmap;
};


static IconData kIcons[] = {
	{ kDocumentOpen, sizeof(kDocumentOpen), NULL },
	{ kDocumentSaveAs, sizeof(kDocumentSaveAs), NULL },
	{ kDocumentSave, sizeof(kDocumentSave), NULL },
	{ kDrawRectangularSelection, sizeof(kDrawRectangularSelection), NULL },
	{ kEditCopy, sizeof(kEditCopy), NULL },
	{ kEditCut, sizeof(kEditCut), NULL },
	{ kEditDelete, sizeof(kEditDelete), NULL },
	{ kEditTrash, sizeof(kEditTrash), NULL },
	{ kMediaMovieLibraryR4, sizeof(kMediaMovieLibraryR4), NULL },
	{ kMediaPlaybackStartEnabled, sizeof(kMediaPlaybackStartEnabled), NULL },
	{ kGoDown, sizeof(kGoDown), NULL },
	{ kGoNext, sizeof(kGoNext), NULL },
	{ kGoPrevious, sizeof(kGoPrevious), NULL },
	{ kGoUp, sizeof(kGoUp), NULL },
	{ kViewFullScreen, sizeof(kViewFullScreen), NULL },
	{ kViewWindowed, sizeof(kViewWindowed), NULL },
	{ kZoomFitBest, sizeof(kZoomFitBest), NULL },
	{ kZoomFitViewBest, sizeof(kZoomFitViewBest), NULL },
	{ kZoomIn, sizeof(kZoomIn), NULL },
	{ kZoomOriginal, sizeof(kZoomOriginal), NULL },
	{ kZoomOut, sizeof(kZoomOut), NULL }
};


status_t
init_tool_bar_icons()
{
	const int32 toolBarIconsSize = 22;
	const int32 iconRenderSize = max_c(toolBarIconsSize, 32);

	BBitmap bitmap(BRect(0, 0, iconRenderSize - 1, iconRenderSize - 1),
		B_BITMAP_NO_SERVER_LINK, B_RGBA32);

	for (uint32 i = 0; i < sizeof(kIcons) / sizeof(IconData); i++) {
		status_t ret = BIconUtils::GetVectorIcon(kIcons[i].data,
			kIcons[i].size, &bitmap);
		if (ret != B_OK)
			return ret;
		kIcons[i].bitmap = new(std::nothrow) BBitmap(BRect(0, 0,
			toolBarIconsSize - 1, toolBarIconsSize - 1), 0, B_RGBA32);
		if (kIcons[i].bitmap == NULL)
			return B_NO_MEMORY;
		ret = kIcons[i].bitmap->InitCheck();
		if (ret != B_OK)
			return ret;
		uint8* src = reinterpret_cast<uint8*>(bitmap.Bits());
		uint32 srcBPR = bitmap.BytesPerRow();
		uint8* dst = reinterpret_cast<uint8*>(kIcons[i].bitmap->Bits());
		uint32 dstBPR = kIcons[i].bitmap->BytesPerRow();
		for (int32 y = 0; y < toolBarIconsSize; y++) {
			memcpy(dst, src, 4 * toolBarIconsSize);
			src += srcBPR;
			dst += dstBPR;
		}
	}

	// Initializing 14 icons on startup takes about 10ms on a Core2Duo @ 2GHz.

	return B_OK;
}


void
uninit_tool_bar_icons()
{
	for (uint32 i = 0; i < sizeof(kIcons) / sizeof(IconData); i++) {
		delete kIcons[i].bitmap;
		kIcons[i].bitmap = NULL;
	}
}


const BBitmap*
tool_bar_icon(uint32 which)
{
	if (which >= sizeof(kIcons) / sizeof(IconData))
		return NULL;
	return kIcons[which].bitmap;
}

